/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.ModelField;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.type.EnumModelClass;
import io.rxmicro.annotation.processor.common.model.type.ListModelClass;
import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.common.model.type.PrimitiveModelClass;
import io.rxmicro.annotation.processor.common.util.DateTimes;
import io.rxmicro.annotation.processor.documentation.component.DescriptionReader;
import io.rxmicro.annotation.processor.documentation.component.ExampleValueBuilder;
import io.rxmicro.annotation.processor.documentation.component.JsonAttributesReader;
import io.rxmicro.annotation.processor.documentation.component.JsonSchemaBuilder;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.common.RxMicroModule;
import io.rxmicro.json.JsonObjectBuilder;
import io.rxmicro.validation.constraint.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Singleton
public final class JsonSchemaBuilderImpl
implements JsonSchemaBuilder {
    private static final String SCHEMA = "$schema";
    private static final String TYPE = "type";
    private static final String PROPERTIES = "properties";
    private static final String REQUIRED = "required";
    private static final String MIN_PROPERTIES = "minProperties";
    private static final String MAX_PROPERTIES = "maxProperties";
    private static final String DESCRIPTION = "description";
    private static final String ITEMS = "items";
    private static final String EXAMPLES = "examples";
    @Inject
    private ExampleValueBuilder exampleValueBuilder;
    @Inject
    private DescriptionReader descriptionReader;
    @Inject
    private JsonAttributesReader jsonAttributesReader;

    @Override
    public Map<String, Object> getJsonObjectSchema(EnvironmentContext environmentContext, String projectDirectory, RestObjectModelClass restObjectModelClass) {
        return this.getJsonObjectSchema(null, projectDirectory, environmentContext, restObjectModelClass);
    }

    private Map<String, Object> getJsonObjectSchema(ModelField modelField, String projectDirectory, EnvironmentContext environmentContext, RestObjectModelClass restObjectModelClass) {
        JsonObjectBuilder builder = new JsonObjectBuilder();
        if (modelField == null) {
            builder.put(SCHEMA, (Object)"http://json-schema.org/schema#");
        }
        builder.put(TYPE, (Object)"object");
        this.readDescription(builder, projectDirectory, modelField, restObjectModelClass);
        JsonObjectBuilder propertiesBuilder = new JsonObjectBuilder();
        for (Map.Entry entry : restObjectModelClass.getParamEntries()) {
            propertiesBuilder.put(((RestModelField)entry.getKey()).getModelName(), this.getJsonSchema(environmentContext, projectDirectory, entry));
        }
        Map properties = propertiesBuilder.build();
        builder.put(PROPERTIES, (Object)properties);
        if (environmentContext.isRxMicroModuleEnabled(RxMicroModule.RX_MICRO_VALIDATION_MODULE)) {
            List required = restObjectModelClass.getParamEntries().stream().filter(e -> ((RestModelField)e.getKey()).getAnnotation(Nullable.class) == null).map(e -> ((RestModelField)e.getKey()).getModelName()).collect(Collectors.toList());
            if (!required.isEmpty()) {
                builder.put(REQUIRED, required);
            }
            builder.put(MIN_PROPERTIES, (Object)required.size());
        } else {
            builder.put(MIN_PROPERTIES, (Object)0);
        }
        builder.put(MAX_PROPERTIES, (Object)properties.size());
        return builder.build();
    }

    private void readDescription(JsonObjectBuilder builder, String projectDirectory, ModelField modelField, RestObjectModelClass restObjectModelClass) {
        Optional<String> descriptionOptional;
        if (modelField != null && (descriptionOptional = this.descriptionReader.readDescription(modelField.getFieldElement(), projectDirectory)).isPresent()) {
            builder.put(DESCRIPTION, (Object)descriptionOptional.get());
            return;
        }
        if (restObjectModelClass != null) {
            this.descriptionReader.readDescription(restObjectModelClass.getModelTypeElement(), projectDirectory).ifPresent(description -> builder.put(DESCRIPTION, description));
        }
    }

    private Map<String, Object> getJsonSchema(EnvironmentContext environmentContext, String projectDirectory, Map.Entry<RestModelField, ModelClass> entry) {
        ModelClass modelClass = entry.getValue();
        if (modelClass.isObject()) {
            return this.getJsonObjectSchema((ModelField)entry.getKey(), projectDirectory, environmentContext, (RestObjectModelClass)modelClass.asObject());
        }
        if (modelClass.isList()) {
            ListModelClass listModelClass = modelClass.asList();
            if (listModelClass.isObjectList()) {
                RestObjectModelClass restObjectModelClass = (RestObjectModelClass)listModelClass.getElementModelClass().asObject();
                return this.getJsonArraySchema(entry.getKey(), projectDirectory, environmentContext, restObjectModelClass, () -> this.getJsonObjectSchema((ModelField)entry.getKey(), projectDirectory, environmentContext, restObjectModelClass));
            }
            if (listModelClass.isEnumList()) {
                EnumModelClass enumModelClass = listModelClass.getElementModelClass().asEnum();
                return this.getJsonArraySchema(entry.getKey(), projectDirectory, environmentContext, null, () -> this.getJsonEnumSchema((RestModelField)entry.getKey(), environmentContext, enumModelClass));
            }
            if (listModelClass.isPrimitiveList()) {
                PrimitiveModelClass primitiveModelClass = listModelClass.getElementModelClass().asPrimitive();
                return this.getJsonArraySchema(entry.getKey(), projectDirectory, environmentContext, null, () -> this.getJsonPrimitiveSchema((RestModelField)entry.getKey(), environmentContext, primitiveModelClass));
            }
            throw new InternalErrorException("Unsupported array item class type: ?", new Object[]{listModelClass.getElementModelClass().getClass()});
        }
        if (modelClass.isPrimitive()) {
            return this.getJsonPrimitiveSchema(entry.getKey(), environmentContext, modelClass.asPrimitive());
        }
        if (modelClass.isEnum()) {
            return this.getJsonEnumSchema(entry.getKey(), environmentContext, modelClass.asEnum());
        }
        throw new InternalErrorException("Unsupported model class type: " + modelClass.getClass(), new Object[0]);
    }

    private Map<String, Object> getJsonArraySchema(RestModelField modelField, String projectDirectory, EnvironmentContext environmentContext, RestObjectModelClass restObjectModelClass, Supplier<Map<String, Object>> itemSupplier) {
        JsonObjectBuilder builder = new JsonObjectBuilder();
        builder.put(TYPE, (Object)"array");
        this.readDescription(builder, projectDirectory, (ModelField)modelField, restObjectModelClass);
        this.jsonAttributesReader.readArrayAttributes(environmentContext, builder, (ModelField)modelField);
        builder.put(ITEMS, itemSupplier.get());
        return builder.build();
    }

    private Map<String, Object> getJsonPrimitiveSchema(RestModelField restModelField, EnvironmentContext environmentContext, PrimitiveModelClass primitiveModelClass) {
        JsonObjectBuilder builder = new JsonObjectBuilder();
        String jsonType = primitiveModelClass.getPrimitiveType().toJsonType();
        builder.put(TYPE, (Object)jsonType);
        if (DateTimes.SUPPORTED_DATE_TIME_CLASSES.contains(primitiveModelClass.getTypeMirror().toString())) {
            this.jsonAttributesReader.readDateTimePrimitiveAttributes(environmentContext, builder, (ModelField)restModelField);
        } else if ("string".equals(jsonType)) {
            this.jsonAttributesReader.readStringPrimitiveAttributes(environmentContext, builder, (ModelField)restModelField);
        } else if ("number".equals(jsonType)) {
            this.jsonAttributesReader.readNumberPrimitiveAttributes(environmentContext, builder, (ModelField)restModelField);
        }
        builder.put(EXAMPLES, this.exampleValueBuilder.getExamples(restModelField));
        return builder.build();
    }

    private Map<String, Object> getJsonEnumSchema(RestModelField restModelField, EnvironmentContext environmentContext, EnumModelClass enumModelClass) {
        JsonObjectBuilder builder = new JsonObjectBuilder();
        builder.put(TYPE, (Object)enumModelClass.getPrimitiveType().toJsonType());
        this.jsonAttributesReader.readEnumAttributes(environmentContext, builder, (ModelField)restModelField, enumModelClass);
        builder.put(EXAMPLES, this.exampleValueBuilder.getExamples(restModelField));
        return builder.build();
    }
}

