/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.ModelField;
import io.rxmicro.annotation.processor.common.model.type.EnumModelClass;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.Numbers;
import io.rxmicro.annotation.processor.documentation.component.JsonAttributesReader;
import io.rxmicro.json.JsonObjectBuilder;
import io.rxmicro.validation.constraint.DomainName;
import io.rxmicro.validation.constraint.Email;
import io.rxmicro.validation.constraint.Enumeration;
import io.rxmicro.validation.constraint.HostName;
import io.rxmicro.validation.constraint.IP;
import io.rxmicro.validation.constraint.Lat;
import io.rxmicro.validation.constraint.Length;
import io.rxmicro.validation.constraint.Lng;
import io.rxmicro.validation.constraint.MaxDouble;
import io.rxmicro.validation.constraint.MaxInt;
import io.rxmicro.validation.constraint.MaxLength;
import io.rxmicro.validation.constraint.MaxNumber;
import io.rxmicro.validation.constraint.MaxSize;
import io.rxmicro.validation.constraint.MinDouble;
import io.rxmicro.validation.constraint.MinInt;
import io.rxmicro.validation.constraint.MinLength;
import io.rxmicro.validation.constraint.MinNumber;
import io.rxmicro.validation.constraint.MinSize;
import io.rxmicro.validation.constraint.Pattern;
import io.rxmicro.validation.constraint.Phone;
import io.rxmicro.validation.constraint.Size;
import io.rxmicro.validation.constraint.Skype;
import io.rxmicro.validation.constraint.SubEnum;
import io.rxmicro.validation.constraint.Telegram;
import io.rxmicro.validation.constraint.URI;
import io.rxmicro.validation.constraint.URLEncoded;
import io.rxmicro.validation.constraint.UniqueItems;
import io.rxmicro.validation.constraint.Viber;
import io.rxmicro.validation.constraint.WhatsApp;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class JsonAttributesReaderImpl
implements JsonAttributesReader {
    private static final String FORMAT = "format";
    private static final String PATTERN = "pattern";
    private static final String MIN_LENGTH = "minLength";
    private static final String MAX_LENGTH = "maxLength";
    private static final String ENUM = "enum";
    private static final String EMAIL = "email";
    private static final String PHONE = "phone";
    private static final String TELEGRAM = "telegram";
    private static final String VIBER = "viber";
    private static final String WHATSAPP = "whatsapp";
    private static final String SKYPE = "skype";
    private static final String URI = "uri";
    private static final String URL_ENCODED = "url-encoded";
    private static final String HOSTNAME = "hostname";
    private static final String DOMAIN_NAME = "domainName";
    private static final String DATE_TIME = "date-time";
    private static final String MINIMUM = "minimum";
    private static final String EXCLUSIVE_MINIMUM = "exclusiveMinimum";
    private static final String MAXIMUM = "maximum";
    private static final String EXCLUSIVE_MAXIMUM = "exclusiveMaximum";
    private static final String MIN_ITEMS = "minItems";
    private static final String MAX_ITEMS = "maxItems";
    private static final String UNIQUE_ITEMS = "uniqueItems";

    @Override
    public void readStringPrimitiveAttributes(EnvironmentContext environmentContext, JsonObjectBuilder builder, ModelField modelField) {
        DomainName domainName;
        Enumeration enumeration;
        MaxLength maxLength;
        MinLength minLength;
        Length length;
        Pattern pattern = (Pattern)modelField.getAnnotation(Pattern.class);
        if (pattern != null && !pattern.off()) {
            builder.put(PATTERN, (Object)pattern.regexp());
        }
        if ((length = (Length)modelField.getAnnotation(Length.class)) != null && !length.off()) {
            builder.put(MIN_LENGTH, (Object)length.value());
            builder.put(MAX_LENGTH, (Object)length.value());
        }
        if ((minLength = (MinLength)modelField.getAnnotation(MinLength.class)) != null && !minLength.off()) {
            builder.put(MIN_LENGTH, (Object)minLength.value());
        }
        if ((maxLength = (MaxLength)modelField.getAnnotation(MaxLength.class)) != null && !maxLength.off()) {
            builder.put(MAX_LENGTH, (Object)maxLength.value());
        }
        if ((enumeration = (Enumeration)modelField.getAnnotation(Enumeration.class)) != null && !enumeration.off()) {
            builder.put(ENUM, List.of(enumeration.value()));
            return;
        }
        Email email = (Email)modelField.getAnnotation(Email.class);
        if (email != null) {
            builder.put(FORMAT, (Object)EMAIL);
            return;
        }
        IP ip = (IP)modelField.getAnnotation(IP.class);
        if (ip != null) {
            if (ip.value().length == 1) {
                builder.put(FORMAT, (Object)ip.value()[0].getJsonFormat());
            } else {
                builder.put(FORMAT, (Object)Arrays.stream(ip.value()).map(IP.Version::getJsonFormat).collect(Collectors.joining(", ")));
            }
            return;
        }
        Phone phone = (Phone)modelField.getAnnotation(Phone.class);
        if (phone != null) {
            builder.put(FORMAT, (Object)PHONE);
            return;
        }
        Telegram telegram = (Telegram)modelField.getAnnotation(Telegram.class);
        if (telegram != null) {
            builder.put(FORMAT, (Object)TELEGRAM);
            return;
        }
        Viber viber = (Viber)modelField.getAnnotation(Viber.class);
        if (viber != null) {
            builder.put(FORMAT, (Object)VIBER);
            return;
        }
        WhatsApp whatsApp = (WhatsApp)modelField.getAnnotation(WhatsApp.class);
        if (whatsApp != null) {
            builder.put(FORMAT, (Object)WHATSAPP);
            return;
        }
        Skype skype = (Skype)modelField.getAnnotation(Skype.class);
        if (skype != null) {
            builder.put(FORMAT, (Object)SKYPE);
            return;
        }
        URI uri = (URI)modelField.getAnnotation(URI.class);
        if (uri != null) {
            builder.put(FORMAT, (Object)URI);
            return;
        }
        URLEncoded urlEncoded = (URLEncoded)modelField.getAnnotation(URLEncoded.class);
        if (urlEncoded != null) {
            builder.put(FORMAT, (Object)URL_ENCODED);
            return;
        }
        HostName hostName = (HostName)modelField.getAnnotation(HostName.class);
        if (hostName != null) {
            builder.put(FORMAT, (Object)HOSTNAME);
        }
        if ((domainName = (DomainName)modelField.getAnnotation(DomainName.class)) != null) {
            builder.put(FORMAT, (Object)DOMAIN_NAME);
        }
    }

    @Override
    public void readDateTimePrimitiveAttributes(EnvironmentContext environmentContext, JsonObjectBuilder builder, ModelField modelField) {
        builder.put(FORMAT, (Object)DATE_TIME);
    }

    @Override
    public void readNumberPrimitiveAttributes(EnvironmentContext environmentContext, JsonObjectBuilder builder, ModelField annotated) {
        MaxNumber maxNumber;
        MaxInt maxInt;
        MaxDouble maxDouble;
        MinNumber minNumber;
        MinInt minInt;
        MinDouble minDouble;
        Lng lng;
        Optional.ofNullable((String)Numbers.NUMBER_FORMATS.get(annotated.getFieldClass().toString())).ifPresent(t -> builder.put(FORMAT, t));
        Lat lat = (Lat)annotated.getAnnotation(Lat.class);
        if (lat != null && !lat.off()) {
            builder.put(MINIMUM, (Object)-90);
            builder.put(EXCLUSIVE_MINIMUM, (Object)false);
            builder.put(MAXIMUM, (Object)90);
            builder.put(EXCLUSIVE_MAXIMUM, (Object)false);
        }
        if ((lng = (Lng)annotated.getAnnotation(Lng.class)) != null && !lng.off()) {
            builder.put(MINIMUM, (Object)-180);
            builder.put(EXCLUSIVE_MINIMUM, (Object)false);
            builder.put(MAXIMUM, (Object)180);
            builder.put(EXCLUSIVE_MAXIMUM, (Object)false);
        }
        if ((minDouble = (MinDouble)annotated.getAnnotation(MinDouble.class)) != null && !minDouble.off()) {
            builder.put(MINIMUM, (Object)minDouble.value());
            builder.put(EXCLUSIVE_MINIMUM, (Object)false);
        }
        if ((minInt = (MinInt)annotated.getAnnotation(MinInt.class)) != null && !minInt.off()) {
            builder.put(MINIMUM, (Object)minInt.value());
            builder.put(EXCLUSIVE_MINIMUM, (Object)(!minInt.inclusive() ? 1 : 0));
        }
        if ((minNumber = (MinNumber)annotated.getAnnotation(MinNumber.class)) != null && !minNumber.off()) {
            builder.put(MINIMUM, (Object)new BigDecimal(Numbers.removeUnderscoresIfPresent((String)minNumber.value())));
            builder.put(EXCLUSIVE_MINIMUM, (Object)(!minNumber.inclusive() ? 1 : 0));
        }
        if ((maxDouble = (MaxDouble)annotated.getAnnotation(MaxDouble.class)) != null && !maxDouble.off()) {
            builder.put(MAXIMUM, (Object)maxDouble.value());
            builder.put(EXCLUSIVE_MAXIMUM, (Object)false);
        }
        if ((maxInt = (MaxInt)annotated.getAnnotation(MaxInt.class)) != null && !maxInt.off()) {
            builder.put(MAXIMUM, (Object)maxInt.value());
            builder.put(EXCLUSIVE_MAXIMUM, (Object)(!maxInt.inclusive() ? 1 : 0));
        }
        if ((maxNumber = (MaxNumber)annotated.getAnnotation(MaxNumber.class)) != null && !maxNumber.off()) {
            builder.put(MAXIMUM, (Object)new BigDecimal(Numbers.removeUnderscoresIfPresent((String)maxNumber.value())));
            builder.put(EXCLUSIVE_MAXIMUM, (Object)(!maxNumber.inclusive() ? 1 : 0));
        }
    }

    @Override
    public void readEnumAttributes(EnvironmentContext environmentContext, JsonObjectBuilder builder, ModelField modelField, EnumModelClass enumModelClass) {
        Set enumConstants = Elements.getAllowedEnumConstants((TypeMirror)enumModelClass.getTypeMirror());
        SubEnum subEnum = (SubEnum)modelField.getAnnotation(SubEnum.class);
        if (subEnum != null && !subEnum.off()) {
            if (subEnum.include().length > 0) {
                builder.put(ENUM, Arrays.asList(subEnum.include()));
            } else {
                LinkedHashSet enums = new LinkedHashSet(enumConstants);
                enums.removeAll(Arrays.asList(subEnum.exclude()));
                builder.put(ENUM, new ArrayList(enums));
            }
        } else {
            builder.put(ENUM, new ArrayList(enumConstants));
        }
    }

    @Override
    public void readArrayAttributes(EnvironmentContext environmentContext, JsonObjectBuilder builder, ModelField modelField) {
        UniqueItems uniqueItems;
        MaxSize maxSize;
        MinSize minSize;
        Size size = (Size)modelField.getAnnotation(Size.class);
        if (size != null && !size.off()) {
            builder.put(MIN_ITEMS, (Object)size.value());
            builder.put(MAX_ITEMS, (Object)size.value());
        }
        if ((minSize = (MinSize)modelField.getAnnotation(MinSize.class)) != null && !minSize.off()) {
            builder.put(MIN_ITEMS, (Object)minSize.value());
        }
        if ((maxSize = (MaxSize)modelField.getAnnotation(MaxSize.class)) != null && !maxSize.off()) {
            builder.put(MAX_ITEMS, (Object)maxSize.value());
        }
        if ((uniqueItems = (UniqueItems)modelField.getAnnotation(UniqueItems.class)) != null && !uniqueItems.off()) {
            builder.put(UNIQUE_ITEMS, (Object)true);
        }
    }
}

