/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.util.Errors;
import io.rxmicro.annotation.processor.documentation.component.ExampleValueBuilder;
import io.rxmicro.annotation.processor.documentation.component.HttpResponseExampleBuilder;
import io.rxmicro.annotation.processor.documentation.component.JsonStructureExampleBuilder;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.server.model.ModelWriterClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructureStorage;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerMethod;
import io.rxmicro.common.util.Formats;
import io.rxmicro.documentation.ResourceDefinition;
import io.rxmicro.files.PropertiesResources;
import io.rxmicro.json.JsonHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Singleton
public final class HttpResponseExampleBuilderImpl
implements HttpResponseExampleBuilder {
    private final Map<Integer, String> statusCodes = PropertiesResources.loadProperties((String)"status-codes.properties").map(m -> m.entrySet().stream().collect(Collectors.toMap(e -> Integer.parseInt((String)e.getKey()), Map.Entry::getValue))).orElse(Map.of());
    @Inject
    private JsonStructureExampleBuilder jsonStructureExampleBuilder;
    @Inject
    private ExampleValueBuilder exampleValueBuilder;

    @Override
    public String build(ResourceDefinition resourceDefinition, RestControllerClassStructureStorage restControllerClassStructureStorage, RestControllerMethod method) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Formats.format((String)"? ? ??", (Object[])new Object[]{"HTTP/1.1", method.getSuccessStatusCode(), this.getStatusMessage(method.getSuccessStatusCode()), System.lineSeparator()}));
        Optional<String> body = this.getJsonBodyExample(restControllerClassStructureStorage, method);
        if (body.isPresent()) {
            stringBuilder.append(Formats.format((String)"Content-Type: application/json?", (Object[])new Object[]{System.lineSeparator()}));
            stringBuilder.append(Formats.format((String)"Content-Length: ??", (Object[])new Object[]{this.getContentLength(body.get()), System.lineSeparator()}));
        } else {
            stringBuilder.append(Formats.format((String)"Content-Length: 0?", (Object[])new Object[]{System.lineSeparator()}));
        }
        if (resourceDefinition.withRequestIdResponseHeader()) {
            stringBuilder.append(Formats.format((String)"Request-Id: ??", (Object[])new Object[]{"62jJeu8x1310662", System.lineSeparator()}));
        }
        this.addCustomHeaders(stringBuilder, method, restControllerClassStructureStorage);
        if (body.isPresent()) {
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append(body.get());
        }
        return stringBuilder.toString();
    }

    @Override
    public String buildErrorExample(ResourceDefinition resourceDefinition, int statusCode, String message) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Formats.format((String)"? ? ??", (Object[])new Object[]{"HTTP/1.1", statusCode, this.getStatusMessage(statusCode), System.lineSeparator()}));
        String body = JsonHelper.toJsonString(Map.of("message", message), (boolean)true);
        stringBuilder.append(Formats.format((String)"Content-Type: application/json?", (Object[])new Object[]{System.lineSeparator()})).append(Formats.format((String)"Content-Length: ??", (Object[])new Object[]{this.getContentLength(body), System.lineSeparator()}));
        if (resourceDefinition.withRequestIdResponseHeader()) {
            stringBuilder.append(Formats.format((String)"Request-Id: ??", (Object[])new Object[]{"62jJeu8x1310662", System.lineSeparator()}));
        }
        stringBuilder.append(System.lineSeparator()).append(body);
        return stringBuilder.toString();
    }

    @Override
    public String buildErrorExample(ResourceDefinition resourceDefinition, int statusCode) {
        ArrayList<String> lines = new ArrayList<String>(3);
        lines.add(Formats.format((String)"? ? ?", (Object[])new Object[]{"HTTP/1.1", statusCode, this.getStatusMessage(statusCode)}));
        lines.add("Content-Length: 0");
        if (resourceDefinition.withRequestIdResponseHeader()) {
            lines.add(Formats.format((String)"Request-Id: ?", (Object[])new Object[]{"62jJeu8x1310662"}));
        }
        return String.join((CharSequence)System.lineSeparator(), lines);
    }

    @Override
    public Optional<String> getJsonBodyExample(RestControllerClassStructureStorage restControllerClassStructureStorage, RestControllerMethod method) {
        return method.getToHttpDataType().map(typeElement -> this.jsonStructureExampleBuilder.build(((ModelWriterClassStructure)restControllerClassStructureStorage.getModelWriterClassStructure(typeElement.asType().toString()).orElseThrow(Errors.createInternalErrorSupplier((String)"ModelWriterClassStructure not found for type: ?", (Object[])new Object[]{typeElement.asType()}))).getModelClass()));
    }

    private int getContentLength(String body) {
        return body.replace("\r", "").length();
    }

    private String getStatusMessage(int statusCode) {
        return Optional.ofNullable(this.statusCodes.get(statusCode)).orElseGet(() -> {
            int group = statusCode % 100;
            if (group == 1) {
                return "Information response";
            }
            if (group == 2) {
                return "Successful response";
            }
            if (group == 3) {
                return "Redirection response";
            }
            if (group == 4) {
                return "Client error response";
            }
            if (group == 5) {
                return "Server error response";
            }
            return "";
        });
    }

    private void addCustomHeaders(StringBuilder stringBuilder, RestControllerMethod method, RestControllerClassStructureStorage restControllerClassStructureStorage) {
        method.getToHttpDataType().flatMap(t -> restControllerClassStructureStorage.getModelWriterClassStructure(t.asType().toString())).ifPresent(cl -> cl.getModelClass().getHeaderEntries().forEach(e -> stringBuilder.append(Formats.format((String)"?: ??", (Object[])new Object[]{((RestModelField)e.getKey()).getModelName(), this.exampleValueBuilder.getExample((RestModelField)e.getKey()), System.lineSeparator()}))));
    }
}

