/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.util.Errors;
import io.rxmicro.annotation.processor.documentation.component.ExampleValueBuilder;
import io.rxmicro.annotation.processor.documentation.component.HttpRequestExampleBuilder;
import io.rxmicro.annotation.processor.documentation.component.JsonStructureExampleBuilder;
import io.rxmicro.annotation.processor.documentation.model.ProjectMetaData;
import io.rxmicro.annotation.processor.rest.model.HttpMethodMapping;
import io.rxmicro.annotation.processor.rest.model.ParentUrl;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.server.model.ModelReaderClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructureStorage;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerMethod;
import io.rxmicro.common.util.Formats;
import io.rxmicro.rest.model.HttpMethod;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.TypeElement;

@Singleton
public final class HttpRequestExampleBuilderImpl
implements HttpRequestExampleBuilder {
    private static final Set<String> SUPPORTED_HTTP_BODY_METHODS = Set.of(HttpMethod.POST.name(), HttpMethod.PUT.name(), HttpMethod.PATCH.name());
    @Inject
    private JsonStructureExampleBuilder jsonStructureExampleBuilder;
    @Inject
    private ExampleValueBuilder exampleValueBuilder;

    @Override
    public String build(ProjectMetaData projectMetaData, ParentUrl parentUrl, HttpMethodMapping httpMethodMapping, RestControllerClassStructureStorage restControllerClassStructureStorage, RestControllerMethod method) {
        String body;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Formats.format((String)"? ?? ??", (Object[])new Object[]{httpMethodMapping.getMethod(), httpMethodMapping.getExactOrTemplateUri(), this.getQueryParameters(httpMethodMapping, method, restControllerClassStructureStorage), "HTTP/1.1", System.lineSeparator()}));
        if (projectMetaData.isBaseEndpointPresent()) {
            stringBuilder.append(Formats.format((String)"Host: ??", (Object[])new Object[]{this.getHost(projectMetaData.getBaseEndpoint()), System.lineSeparator()}));
        }
        stringBuilder.append(Formats.format((String)"Accept: application/json?", (Object[])new Object[]{System.lineSeparator()}));
        if (parentUrl.isHeaderVersionStrategy()) {
            stringBuilder.append(Formats.format((String)"?: ??", (Object[])new Object[]{parentUrl.getVersionHeaderName(), parentUrl.getVersionValue(), System.lineSeparator()}));
        }
        if ((body = this.getRequestHttpBodyOrNull(httpMethodMapping, method, restControllerClassStructureStorage)) != null) {
            stringBuilder.append(Formats.format((String)"Content-Type: application/json?", (Object[])new Object[]{System.lineSeparator()}));
            stringBuilder.append(Formats.format((String)"Content-Length: ??", (Object[])new Object[]{this.getContentLength(body), System.lineSeparator()}));
        } else if (httpMethodMapping.isHttpBody() || SUPPORTED_HTTP_BODY_METHODS.contains(httpMethodMapping.getMethod())) {
            stringBuilder.append(Formats.format((String)"Content-Length: 0?", (Object[])new Object[]{System.lineSeparator()}));
        }
        this.addCustomHeaders(stringBuilder, method, restControllerClassStructureStorage);
        if (body != null) {
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append(body);
        }
        return stringBuilder.toString();
    }

    private int getContentLength(String body) {
        return body.replace("\r", "").length();
    }

    private String getHost(String baseEndpoint) {
        if (baseEndpoint.startsWith("http://")) {
            return baseEndpoint.substring(7);
        }
        if (baseEndpoint.startsWith("https://")) {
            return baseEndpoint.substring(8);
        }
        return baseEndpoint;
    }

    private String getQueryParameters(HttpMethodMapping httpMethodMapping, RestControllerMethod method, RestControllerClassStructureStorage restControllerClassStructureStorage) {
        Optional requestModel = method.getFromHttpDataType();
        if (!httpMethodMapping.isHttpBody() && requestModel.isPresent()) {
            ModelReaderClassStructure modelReaderClassStructure = (ModelReaderClassStructure)restControllerClassStructureStorage.getModelReaderClassStructure(((TypeElement)requestModel.get()).asType().toString()).orElseThrow(Errors.createInternalErrorSupplier((String)"ModelReaderClassStructure not found for type: ?", (Object[])new Object[]{((TypeElement)requestModel.get()).asType()}));
            StringBuilder queryBuilder = new StringBuilder();
            for (Map.Entry entry : modelReaderClassStructure.getModelClass().getParamEntries()) {
                if (queryBuilder.length() > 0) {
                    queryBuilder.append('&');
                }
                queryBuilder.append(((RestModelField)entry.getKey()).getModelName()).append('=').append(this.exampleValueBuilder.getExample((RestModelField)entry.getKey()));
            }
            return queryBuilder.length() > 0 ? "?" + queryBuilder.toString() : "";
        }
        return "";
    }

    private String getRequestHttpBodyOrNull(HttpMethodMapping httpMethodMapping, RestControllerMethod method, RestControllerClassStructureStorage restControllerClassStructureStorage) {
        Optional requestModel = method.getFromHttpDataType();
        if (httpMethodMapping.isHttpBody() && requestModel.isPresent()) {
            return this.jsonStructureExampleBuilder.build(((ModelReaderClassStructure)restControllerClassStructureStorage.getModelReaderClassStructure(((TypeElement)requestModel.get()).asType().toString()).orElseThrow(Errors.createInternalErrorSupplier((String)"ModelReaderClassStructure not found for type: ?", (Object[])new Object[]{((TypeElement)requestModel.get()).asType()}))).getModelClass());
        }
        return null;
    }

    private void addCustomHeaders(StringBuilder stringBuilder, RestControllerMethod method, RestControllerClassStructureStorage restControllerClassStructureStorage) {
        method.getFromHttpDataType().flatMap(t -> restControllerClassStructureStorage.getModelReaderClassStructure(t.asType().toString())).ifPresent(cl -> cl.getModelClass().getHeaderEntries().forEach(e -> stringBuilder.append(Formats.format((String)"?: ??", (Object[])new Object[]{((RestModelField)e.getKey()).getModelName(), this.exampleValueBuilder.getExample((RestModelField)e.getKey()), System.lineSeparator()}))));
    }
}

