/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.documentation.component.ExternalResourceReader;
import io.rxmicro.common.CheckedWrapperException;
import io.rxmicro.common.InvalidStateException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Scanner;
import javax.lang.model.element.Element;

@Singleton
public final class ExternalResourceReaderImpl
implements ExternalResourceReader {
    @Override
    public String read(Element element, String resourcePath) {
        if (resourcePath.startsWith("http://") || resourcePath.startsWith("https://")) {
            return this.readFromHttpResource(resourcePath);
        }
        Path filePath = Paths.get(resourcePath, new String[0]);
        if (Files.exists(filePath, new LinkOption[0])) {
            return this.readFromFile(filePath);
        }
        throw new InterruptProcessingException(element, "File not found: ?", new Object[]{filePath.toAbsolutePath()});
    }

    private String readFromFile(Path filePath) {
        try {
            return Files.readString(filePath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new CheckedWrapperException((Throwable)e, "Can't read data from file: ?", new Object[]{filePath.toAbsolutePath()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readFromHttpResource(String resourcePath) {
        try (Scanner scanner = new Scanner(new URL(resourcePath).openStream(), StandardCharsets.UTF_8);){
            scanner.useDelimiter("\\A");
            if (scanner.hasNext()) {
                String string = scanner.next();
                return string;
            }
            throw new InvalidStateException("Can't read data from http resource: ?: Empty content", new Object[]{resourcePath});
        }
        catch (IOException e) {
            throw new CheckedWrapperException((Throwable)e, "Can't read data from http resource: ?", new Object[]{resourcePath});
        }
    }
}

