/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.PathVariablesResolver;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.documentation.component.CustomSectionsReader;
import io.rxmicro.annotation.processor.documentation.component.ExternalResourceReader;
import io.rxmicro.annotation.processor.documentation.component.IncludeReferenceSyntaxProvider;
import io.rxmicro.annotation.processor.documentation.model.ProjectMetaData;
import io.rxmicro.documentation.IncludeMode;
import io.rxmicro.documentation.IntroductionDefinition;
import io.rxmicro.documentation.ResourceGroupDefinition;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;

@Singleton
public final class CustomSectionsReaderImpl
implements CustomSectionsReader {
    @Inject
    private PathVariablesResolver pathVariablesResolver;
    @Inject
    private ExternalResourceReader externalResourceReader;

    @Override
    public List<String> read(Element owner, IntroductionDefinition introductionDefinition, ProjectMetaData projectMetaData, IncludeReferenceSyntaxProvider includeReferenceSyntaxProvider) {
        this.validateParameters(owner, introductionDefinition.customSection().length, (int)Arrays.stream(introductionDefinition.sectionOrder()).filter(s -> s == IntroductionDefinition.Section.CUSTOM_SECTION).count());
        return this.read(owner, introductionDefinition.customSection(), introductionDefinition.includeMode(), projectMetaData, includeReferenceSyntaxProvider);
    }

    @Override
    public List<String> read(Element owner, ResourceGroupDefinition resourceGroupDefinition, ProjectMetaData projectMetaData, IncludeReferenceSyntaxProvider includeReferenceSyntaxProvider) {
        this.validateParameters(owner, resourceGroupDefinition.customSection().length, (int)Arrays.stream(resourceGroupDefinition.sectionOrder()).filter(s -> s == ResourceGroupDefinition.Section.CUSTOM_SECTION).count());
        return this.read(owner, resourceGroupDefinition.customSection(), resourceGroupDefinition.includeMode(), projectMetaData, includeReferenceSyntaxProvider);
    }

    private void validateParameters(Element owner, int customSectionLength, int customSectionsCount) {
        if (customSectionLength < customSectionsCount) {
            throw new InterruptProcessingException(owner, "Missing custom section resource", new Object[0]);
        }
        if (customSectionLength > customSectionsCount) {
            throw new InterruptProcessingException(owner, "Redundant custom section resource", new Object[0]);
        }
    }

    private List<String> read(Element owner, String[] customSection, IncludeMode includeMode, ProjectMetaData projectMetaData, IncludeReferenceSyntaxProvider includeReferenceSyntaxProvider) {
        if (customSection.length == 0) {
            return List.of();
        }
        if (includeMode == IncludeMode.INCLUDE_REFERENCE) {
            return Arrays.stream(customSection).map(v -> includeReferenceSyntaxProvider.include(this.pathVariablesResolver.resolvePathVariables(owner, projectMetaData.getProjectDirectory(), v))).collect(Collectors.toList());
        }
        if (includeMode == IncludeMode.INLINE_CONTENT) {
            return Arrays.stream(customSection).map(v -> this.externalResourceReader.read(owner, this.pathVariablesResolver.resolvePathVariables(owner, projectMetaData.getProjectDirectory(), v))).collect(Collectors.toList());
        }
        throw new InternalErrorException("Include mode not supported: ?", new Object[]{includeMode});
    }
}

