/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.common.component.impl.AbstractModuleClassStructuresBuilder;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.data.component.DataClassStructureBuilder;
import io.rxmicro.annotation.processor.data.component.DataGenerationContextBuilder;
import io.rxmicro.annotation.processor.data.component.DataRepositoryInterfaceSignatureBuilder;
import io.rxmicro.annotation.processor.data.component.EntityConverterBuilder;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.model.DataModelField;
import io.rxmicro.annotation.processor.data.model.DataObjectModelClass;
import io.rxmicro.annotation.processor.data.model.DataRepositoryInterfaceSignature;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;

public abstract class AbstractDataModuleClassStructuresBuilder<DMF extends DataModelField, DMC extends DataObjectModelClass<DMF>>
extends AbstractModuleClassStructuresBuilder {
    @Inject
    private DataRepositoryInterfaceSignatureBuilder dataRepositoryInterfaceSignatureBuilder;
    @Inject
    private DataGenerationContextBuilder<DMF, DMC> dataGenerationContextBuilder;
    @Inject
    private DataClassStructureBuilder<DMF, DMC> dataClassStructureBuilder;
    @Inject
    private EntityConverterBuilder<DMF, DMC> entityConverterBuilder;

    public final Set<? extends ClassStructure> buildClassStructures(EnvironmentContext environmentContext, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            Set<DataRepositoryInterfaceSignature> signatures = this.dataRepositoryInterfaceSignatureBuilder.build(environmentContext, annotations, roundEnv);
            DataGenerationContext<DMF, DMC> dataGenerationContext = this.dataGenerationContextBuilder.build(environmentContext.getCurrentModule(), new ArrayList<DataRepositoryInterfaceSignature>(signatures));
            Set result = signatures.stream().map(signature -> this.dataClassStructureBuilder.build(environmentContext, (DataRepositoryInterfaceSignature)((Object)signature), dataGenerationContext)).collect(Collectors.toSet());
            result.addAll(this.entityConverterBuilder.build(dataGenerationContext));
            return result;
        }
        catch (InterruptProcessingException ex) {
            this.error(ex);
            return Set.of();
        }
    }
}

