/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.model;

import io.rxmicro.annotation.processor.common.model.method.MethodBody;
import io.rxmicro.annotation.processor.data.model.DataRepositoryMethodSignature;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.type.TypeMirror;

public abstract class DataRepositoryMethod {
    private final DataRepositoryMethodSignature methodSignature;
    private final MethodBody body;

    public DataRepositoryMethod(DataRepositoryMethodSignature methodSignature, MethodBody body) {
        this.methodSignature = (DataRepositoryMethodSignature)Requires.require((Object)methodSignature);
        this.body = (MethodBody)Requires.require((Object)body);
    }

    public Set<TypeMirror> getParamEntityClasses() {
        return this.methodSignature.getParamEntityClasses();
    }

    public Set<TypeMirror> getReturnEntityClasses() {
        return this.methodSignature.getReturnEntityClasses();
    }

    public String getReturnType() {
        return this.methodSignature.getMethodResult().getHumanReadableReturnType();
    }

    public String getName() {
        return this.methodSignature.getMethod().getSimpleName().toString();
    }

    public String getParams() {
        return this.methodSignature.getParams().stream().map(e -> Formats.format((String)"final ? ?", (Object[])new Object[]{e.getSimpleType(), e.getName()})).collect(Collectors.joining(", "));
    }

    public List<String> getBodyLines() {
        return this.body.getLines();
    }
}

