/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.component.impl;

import io.rxmicro.annotation.processor.common.component.impl.AbstractProcessorComponent;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.data.component.DataClassStructureBuilder;
import io.rxmicro.annotation.processor.data.component.DataRepositoryMethodModelBuilder;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.model.DataModelField;
import io.rxmicro.annotation.processor.data.model.DataObjectModelClass;
import io.rxmicro.annotation.processor.data.model.DataRepositoryInterfaceSignature;
import io.rxmicro.annotation.processor.data.model.DataRepositoryMethod;
import io.rxmicro.annotation.processor.data.model.DataRepositoryMethodSignature;
import io.rxmicro.data.DataRepositoryGeneratorConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;

public abstract class AbstractDataClassStructureBuilder<DMF extends DataModelField, DMC extends DataObjectModelClass<DMF>>
extends AbstractProcessorComponent
implements DataClassStructureBuilder<DMF, DMC> {
    protected final <DRM extends DataRepositoryMethod> List<DRM> buildMethods(Set<? extends DataRepositoryMethodModelBuilder<DMF, DRM, DMC>> dataRepositoryMethodModelBuilders, EnvironmentContext environmentContext, DataGenerationContext<DMF, DMC> dataGenerationContext, DataRepositoryInterfaceSignature signature, ClassHeader.Builder classHeaderBuilder) {
        AtomicInteger count = new AtomicInteger(0);
        DataRepositoryGeneratorConfig dataRepositoryGeneratorConfig = Optional.ofNullable(signature.getRepositoryInterface().getAnnotation(DataRepositoryGeneratorConfig.class)).orElseGet(() -> (DataRepositoryGeneratorConfig)Annotations.getPresentOrDefaultAnnotation((AnnotatedConstruct)environmentContext.getCurrentModule(), DataRepositoryGeneratorConfig.class));
        ArrayList methods = new ArrayList();
        signature.getMethods().forEach(methodSignature -> {
            try {
                count.incrementAndGet();
                methods.add(this.getMethodBuilder(dataRepositoryMethodModelBuilders, (DataRepositoryMethodSignature)methodSignature, dataGenerationContext).build((DataRepositoryMethodSignature)methodSignature, classHeaderBuilder, dataRepositoryGeneratorConfig, dataGenerationContext));
            }
            catch (InterruptProcessingException e) {
                this.error(e);
            }
        });
        if (count.get() != methods.size()) {
            throw new InterruptProcessingException((Element)signature.getRepositoryInterface(), "Repository class couldn't be generated because some methods have errors. Fix these errors and compile again.", new Object[0]);
        }
        return methods;
    }

    private <DRM extends DataRepositoryMethod> DataRepositoryMethodModelBuilder<DMF, DRM, DMC> getMethodBuilder(Set<? extends DataRepositoryMethodModelBuilder<DMF, DRM, DMC>> dataRepositoryMethodModelBuilders, DataRepositoryMethodSignature methodSignature, DataGenerationContext<DMF, DMC> dataGenerationContext) {
        Set methodModelBuilders = dataRepositoryMethodModelBuilders.stream().filter(methodBuilder -> methodBuilder.isSupported(methodSignature, dataGenerationContext)).collect(Collectors.toSet());
        if (methodModelBuilders.isEmpty()) {
            throw new InterruptProcessingException((Element)methodSignature.getMethod(), "The RxMicro framework does not know how to generate a body of this method: Missing operation annotation.", new Object[0]);
        }
        if (methodModelBuilders.size() > 1) {
            throw new InterruptProcessingException((Element)methodSignature.getMethod(), "Repository method has ambiguous definitions: ?", new Object[]{methodModelBuilders});
        }
        return (DataRepositoryMethodModelBuilder)methodModelBuilders.iterator().next();
    }
}

