/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.model;

import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.common.model.definition.TypeDefinitions;
import io.rxmicro.annotation.processor.common.model.method.MethodParameter;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.common.util.Requires;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

public final class DataRepositoryMethodSignature {
    private final SupportedTypesProvider supportedTypesProvider;
    private final ExecutableElement method;
    private final boolean operationReturnVoid;
    private final MethodResult methodResult;
    private final List<MethodParameter> params;

    public DataRepositoryMethodSignature(SupportedTypesProvider supportedTypesProvider, ExecutableElement method, boolean operationReturnVoid, MethodResult methodResult, List<MethodParameter> params) {
        this.supportedTypesProvider = (SupportedTypesProvider)Requires.require((Object)supportedTypesProvider);
        this.method = (ExecutableElement)Requires.require((Object)method);
        this.operationReturnVoid = operationReturnVoid;
        this.methodResult = (MethodResult)Requires.require((Object)methodResult);
        this.params = (List)Requires.require(params);
    }

    public ExecutableElement getMethod() {
        return this.method;
    }

    public MethodResult getMethodResult() {
        return this.methodResult;
    }

    public List<MethodParameter> getParams() {
        return this.params;
    }

    public Set<TypeMirror> getParamEntityClasses() {
        TypeDefinitions notEntityMethodParameters = this.supportedTypesProvider.notEntityMethodParameters();
        return this.params.stream().map(MethodParameter::getType).filter(p -> !notEntityMethodParameters.contains(p) && !p.getKind().isPrimitive()).collect(Collectors.toSet());
    }

    public Set<TypeMirror> getReturnEntityClasses() {
        TypeDefinitions primitives = this.supportedTypesProvider.resultReturnPrimitiveTypes();
        if (this.methodResult.isVoid() || primitives.contains(this.methodResult.getResultType()) || this.operationReturnVoid || this.getParamEntityClasses().contains(this.methodResult.getResultType())) {
            return Set.of();
        }
        return Set.of(this.methodResult.getResultType());
    }
}

