/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.model;

import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.ModelTransformer;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.data.model.DataRepositoryMethod;
import io.rxmicro.common.util.ExCollectors;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import io.rxmicro.data.local.EntityFromDBConverter;
import io.rxmicro.data.local.EntityToDBConverter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.TypeElement;

public abstract class DataRepositoryClassStructure
extends ClassStructure {
    protected final ClassHeader.Builder classHeaderBuilder;
    protected final TypeElement repositoryInterface;
    protected final TypeElement abstractClass;
    protected final String configNameSpace;
    protected final List<? extends DataRepositoryMethod> methods;
    protected final Set<ModelTransformer> modelTransformers;
    private final List<Map.Entry<String, String>> defaultConfigValues;

    protected DataRepositoryClassStructure(ClassHeader.Builder classHeaderBuilder, TypeElement repositoryInterface, TypeElement abstractClass, String configNameSpace, List<? extends DataRepositoryMethod> methods, List<Map.Entry<String, String>> defaultConfigValues) {
        this.classHeaderBuilder = (ClassHeader.Builder)Requires.require((Object)classHeaderBuilder);
        this.repositoryInterface = (TypeElement)Requires.require((Object)repositoryInterface);
        this.abstractClass = (TypeElement)Requires.require((Object)abstractClass);
        this.configNameSpace = (String)Requires.require((Object)configNameSpace);
        this.methods = (List)Requires.require(methods);
        this.defaultConfigValues = (List)Requires.require(defaultConfigValues);
        this.modelTransformers = this.getModelTransformers();
    }

    public List<Map.Entry<String, String>> getDefaultConfigValues() {
        return this.defaultConfigValues;
    }

    public final String getSimpleInterfaceName() {
        return Names.getSimpleName((String)this.getFullInterfaceName());
    }

    public final String getConfigNameSpace() {
        return this.configNameSpace;
    }

    public final String getFullInterfaceName() {
        return this.repositoryInterface.asType().toString();
    }

    public final String getTargetSimpleClassName() {
        return Formats.format((String)"???", (Object[])new Object[]{"$$", this.getRepositoryTypePrefix(), this.getSimpleInterfaceName()});
    }

    public final String getTargetFullClassName() {
        return this.getPackageName() + "." + this.getTargetSimpleClassName();
    }

    protected abstract String getRepositoryTypePrefix();

    protected final String getPackageName() {
        return Names.getPackageName((TypeElement)this.repositoryInterface);
    }

    private Set<ModelTransformer> getModelTransformers() {
        return (Set)Stream.concat(this.methods.stream().flatMap(m -> m.getParamEntityClasses().stream()).map(cl -> new ModelTransformer(cl, this.getEntityToDBConverterClass())), this.methods.stream().flatMap(m -> m.getReturnEntityClasses().stream()).map(cl -> new ModelTransformer(cl, this.getEntityFromDBConverterClass()))).collect(ExCollectors.toTreeSet());
    }

    protected abstract Class<? extends EntityToDBConverter> getEntityToDBConverterClass();

    protected abstract Class<? extends EntityFromDBConverter> getEntityFromDBConverterClass();
}

