/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.component.impl;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.common.component.MethodParametersBuilder;
import io.rxmicro.annotation.processor.common.component.MethodResultBuilder;
import io.rxmicro.annotation.processor.common.component.impl.AbstractMethodSignatureBuilder;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.SupportedAnnotations;
import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.validators.AnnotationValidators;
import io.rxmicro.annotation.processor.data.component.DataRepositoryMethodSignatureBuilder;
import io.rxmicro.annotation.processor.data.model.DataRepositoryMethodSignature;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public abstract class AbstractDataRepositoryMethodSignatureBuilder
extends AbstractMethodSignatureBuilder
implements DataRepositoryMethodSignatureBuilder {
    @Inject
    private SupportedTypesProvider supportedTypesProvider;
    @Inject
    private MethodResultBuilder methodResultBuilder;
    @Inject
    private MethodParametersBuilder methodParametersBuilder;

    @Override
    public final List<DataRepositoryMethodSignature> build(EnvironmentContext environmentContext, TypeElement restClientInterface, Map.Entry<TypeElement, List<ExecutableElement>> overriddenMethodCandidates) {
        List methods = Elements.allImplementableMethods((TypeElement)restClientInterface);
        this.validateMethods(methods, overriddenMethodCandidates.getValue());
        return methods.stream().filter(e -> this.notContainIn((ExecutableElement)e, (List)overriddenMethodCandidates.getValue())).map(method -> new DataRepositoryMethodSignature(this.supportedTypesProvider, (ExecutableElement)method, this.getOperationReturnVoidSet().stream().anyMatch(cl -> method.getAnnotation(cl) != null), this.methodResultBuilder.build(method, this.supportedTypesProvider), this.methodParametersBuilder.build(environmentContext, method, this.supportedTypesProvider))).collect(Collectors.toList());
    }

    protected abstract Set<Class<? extends Annotation>> getOperationReturnVoidSet();

    private void validateMethods(List<ExecutableElement> methods, List<ExecutableElement> overriddenMethods) {
        for (ExecutableElement method : methods) {
            List<? extends AnnotationMirror> annotations = method.getAnnotationMirrors();
            AnnotationValidators.validateRedundantAnnotationsPerElement((Element)method, annotations, (SupportedAnnotations)this.getSupportedAnnotations(), (String)"Repository method");
            annotations.stream().filter(annotation -> this.getSupportedAnnotations().isAnnotationSupported(annotation.getAnnotationType())).findFirst().ifPresent(annotation -> this.validateAnnotatedInterfaceMethodModifiers(method, (AnnotationMirror)annotation));
            if (!overriddenMethods.stream().anyMatch(otherMethod -> Elements.methodSignatureEquals((ExecutableElement)method, (ExecutableElement)otherMethod))) continue;
            AnnotationValidators.validateNoRxMicroAnnotationsPerElement((Element)method, (String)"current method is already implemented");
        }
    }
}

