/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.model;

import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import java.util.Objects;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class Var {
    private final TypeMirror type;
    private final String name;
    private final String getter;

    public Var(VariableElement element) {
        this(element.asType(), element.getSimpleName().toString());
    }

    public Var(VariableElement element, String getter) {
        this(element.asType(), element.getSimpleName().toString(), getter);
    }

    public Var(TypeMirror type, String name) {
        this(type, name, name);
    }

    public Var(TypeMirror type, String name, String getter) {
        this.type = (TypeMirror)Requires.require((Object)type);
        this.name = (String)Requires.require((Object)name);
        this.getter = (String)Requires.require((Object)getter);
    }

    public String getGetter() {
        return this.getter;
    }

    public String getName() {
        return this.name;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public boolean is(Class<?> type) {
        return type.getName().equals(this.type.toString());
    }

    public int hashCode() {
        return Objects.hash(this.type.toString(), this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Var var = (Var)o;
        return this.type.toString().equals(var.type.toString()) && this.name.equals(var.name);
    }

    public String toString() {
        return Formats.format((String)"? ?", (Object[])new Object[]{this.type, this.name});
    }
}

