/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.model;

import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.data.model.DataModelField;
import io.rxmicro.annotation.processor.data.model.DataObjectModelClass;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.Requires;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public final class DataGenerationContext<DMF extends DataModelField, DMC extends DataObjectModelClass<DMF>> {
    private final ModuleElement currentModule;
    private final Map<TypeElement, DMC> entityParamMap;
    private final Map<TypeElement, DMC> entityReturnMap;

    public DataGenerationContext(ModuleElement currentModule, Map<TypeElement, DMC> entityParamMap, Map<TypeElement, DMC> entityReturnMap) {
        this.currentModule = (ModuleElement)Requires.require((Object)currentModule);
        this.entityParamMap = ExCollections.unmodifiableMap(entityParamMap);
        this.entityReturnMap = ExCollections.unmodifiableMap(entityReturnMap);
    }

    public ModuleElement getCurrentModule() {
        return this.currentModule;
    }

    public Map<TypeElement, DMC> getEntityParamMap() {
        return this.entityParamMap;
    }

    public Map<TypeElement, DMC> getEntityReturnMap() {
        return this.entityReturnMap;
    }

    public Set<String> getEntityResultTypes() {
        return this.entityReturnMap.keySet().stream().map(t -> t.asType().toString()).collect(Collectors.toSet());
    }

    public Optional<DMC> getEntityParamModel(TypeMirror type) {
        return Elements.asTypeElement((TypeMirror)type).flatMap(e -> Optional.ofNullable((DataObjectModelClass)((Object)((Object)this.entityParamMap.get(e)))));
    }

    public boolean isEntityParamType(TypeMirror type) {
        return Elements.asTypeElement((TypeMirror)type).map(this.entityParamMap::containsKey).orElse(false);
    }

    public boolean isEntityResultType(TypeMirror type) {
        return Elements.asTypeElement((TypeMirror)type).map(this.entityReturnMap::containsKey).orElse(false);
    }
}

