/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.component.impl;

import com.google.inject.Inject;
import io.reactivex.rxjava3.core.Single;
import io.rxmicro.annotation.processor.common.component.MethodBodyGenerator;
import io.rxmicro.annotation.processor.common.component.impl.AbstractProcessorComponent;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.common.model.definition.TypeDefinition;
import io.rxmicro.annotation.processor.common.model.definition.TypeDefinitions;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodBody;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.data.component.DataRepositoryMethodModelBuilder;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.model.DataModelField;
import io.rxmicro.annotation.processor.data.model.DataObjectModelClass;
import io.rxmicro.annotation.processor.data.model.DataRepositoryMethod;
import io.rxmicro.annotation.processor.data.model.DataRepositoryMethodSignature;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.data.DataRepositoryGeneratorConfig;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import reactor.core.publisher.Mono;

public abstract class AbstractDataRepositoryMethodModelBuilder<DMF extends DataModelField, DRM extends DataRepositoryMethod, DMC extends DataObjectModelClass<DMF>>
extends AbstractProcessorComponent
implements DataRepositoryMethodModelBuilder<DMF, DRM, DMC> {
    @Inject
    protected SupportedTypesProvider supportedTypesProvider;
    @Inject
    protected MethodBodyGenerator methodBodyGenerator;

    @Override
    public DRM build(DataRepositoryMethodSignature dataRepositoryMethodSignature, ClassHeader.Builder classHeaderBuilder, DataRepositoryGeneratorConfig dataRepositoryGeneratorConfig, DataGenerationContext<DMF, DMC> dataGenerationContext) {
        ExecutableElement repositoryMethod = dataRepositoryMethodSignature.getMethod();
        MethodResult methodResult = dataRepositoryMethodSignature.getMethodResult();
        classHeaderBuilder.addImports(methodResult.getRequiredImports().toArray(ExCollections.EMPTY_STRING_ARRAY));
        dataRepositoryMethodSignature.getParams().forEach(p -> classHeaderBuilder.addImports(p.getRequiredImports().toArray(ExCollections.EMPTY_STRING_ARRAY)));
        this.addCommonImports(classHeaderBuilder, methodResult);
        MethodBody body = this.buildBody(classHeaderBuilder, repositoryMethod, methodResult, dataRepositoryGeneratorConfig, dataGenerationContext);
        return this.build(dataRepositoryMethodSignature, body);
    }

    protected abstract DRM build(DataRepositoryMethodSignature var1, MethodBody var2);

    protected abstract MethodBody buildBody(ClassHeader.Builder var1, ExecutableElement var2, MethodResult var3, DataRepositoryGeneratorConfig var4, DataGenerationContext<DMF, DMC> var5);

    protected final TypeDefinitions<TypeDefinition> allowedPrimitives() {
        return this.supportedTypesProvider.primitives();
    }

    protected final void validateRequiredReturnType(ExecutableElement repositoryMethod, MethodResult methodResult) {
        if (methodResult.isOptional()) {
            throw new InterruptProcessingException((Element)repositoryMethod, "Method couldn't return a OPTIONAL single reactive result. It must be a REQUIRED single one. (For example ?<RESULT_TYPE>, ?<RESULT_TYPE>, ?<RESULT_TYPE>, ?<RESULT_TYPE>, etc)", new Object[]{Mono.class.getSimpleName(), Single.class.getSimpleName(), CompletableFuture.class.getSimpleName(), CompletionStage.class.getSimpleName()});
        }
    }

    protected final void validateSingleReturnType(ExecutableElement repositoryMethod, MethodResult methodResult) {
        if (!methodResult.isOneItem()) {
            throw new InterruptProcessingException((Element)repositoryMethod, "Method couldn't return a LIST reactive result. It must be a SINGLE one. (For example ?<RESULT_TYPE>, ?<RESULT_TYPE>, ?<RESULT_TYPE>, ?<RESULT_TYPE>, etc)", new Object[]{Mono.class.getSimpleName(), Single.class.getSimpleName(), CompletableFuture.class.getSimpleName(), CompletionStage.class.getSimpleName()});
        }
    }

    protected final void validateRequiredSingleReturnType(ExecutableElement repositoryMethod, MethodResult methodResult) {
        this.validateSingleReturnType(repositoryMethod, methodResult);
        this.validateRequiredReturnType(repositoryMethod, methodResult);
    }

    protected final void validateReactiveTypeWithExcluded(ExecutableElement repositoryMethod, MethodResult methodResult, Class<?> ... excludeReactiveTypes) {
        for (Class<?> reactiveType : excludeReactiveTypes) {
            if (!methodResult.isReactiveType(reactiveType)) continue;
            throw new InterruptProcessingException((Element)repositoryMethod, "Method must return a reactive result of the following types only: ?", new Object[]{this.supportedTypesProvider.reactiveReturnTypes().typeDefinitions().stream().filter(td -> Set.of(excludeReactiveTypes).stream().noneMatch(cl -> cl.getName().equals(td.toString()))).map(Objects::toString).collect(Collectors.joining(", "))});
        }
    }

    protected final void validateReturnType(ExecutableElement repositoryMethod, TypeMirror resultType, Class<?> ... supportedClasses) {
        this.validateReturnType(repositoryMethod, resultType, List.of(), (String[])Arrays.stream(supportedClasses).map(Class::getName).toArray(String[]::new));
    }

    protected final void validateReturnType(ExecutableElement repositoryMethod, TypeMirror resultType, Collection<String> supportedClasses) {
        this.validateReturnType(repositoryMethod, resultType, List.of(), supportedClasses.toArray(ExCollections.EMPTY_STRING_ARRAY));
    }

    protected final void validateReturnType(ExecutableElement repositoryMethod, TypeMirror resultType, String ... supportedClasses) {
        this.validateReturnType(repositoryMethod, resultType, List.of(), supportedClasses);
    }

    protected final void validateReturnType(ExecutableElement repositoryMethod, TypeMirror resultType, List<TypeDefinitions<? extends TypeDefinition>> typeDefinitions) {
        this.validateReturnType(repositoryMethod, resultType, typeDefinitions, ExCollections.EMPTY_STRING_ARRAY);
    }

    protected final void validateReturnType(ExecutableElement repositoryMethod, TypeMirror resultType, Collection<TypeDefinitions<? extends TypeDefinition>> typeDefinitions, String ... supportedClasses) {
        this.validateReturnType(repositoryMethod, resultType, typeDefinitions, List.of(supportedClasses));
    }

    protected final void validateReturnType(ExecutableElement repositoryMethod, TypeMirror resultType, Collection<TypeDefinitions<? extends TypeDefinition>> typeDefinitions, Collection<String> supportedClasses) {
        for (TypeDefinitions<? extends TypeDefinition> typeDefinition : typeDefinitions) {
            if (!typeDefinition.contains(resultType)) continue;
            return;
        }
        if (supportedClasses.contains(resultType.toString())) {
            return;
        }
        throw new InterruptProcessingException((Element)repositoryMethod, "Method must return a reactive result of the following types only: ?", new Object[]{Stream.concat(typeDefinitions.stream().flatMap(v -> v.typeDefinitions().stream().map(Object::toString)), supportedClasses.stream()).collect(Collectors.toList())});
    }

    protected final void putCommonArguments(DataRepositoryGeneratorConfig dataRepositoryGeneratorConfig, Map<String, Object> templateArguments) {
        templateArguments.put("SHOW_ORIGINAL_QUERY", dataRepositoryGeneratorConfig.addOriginalQueryToGeneratedCodeAsComment());
    }

    protected void addCommonImports(ClassHeader.Builder classHeaderBuilder, MethodResult methodResult) {
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public String toString() {
        return this.operationType().getSimpleName();
    }
}

