/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.component.impl;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.common.component.impl.AbstractPartialImplementationBuilder;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.data.component.DataRepositoryInterfaceSignatureBuilder;
import io.rxmicro.annotation.processor.data.component.DataRepositoryMethodSignatureBuilder;
import io.rxmicro.annotation.processor.data.model.DataRepositoryInterfaceSignature;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public abstract class AbstractDataRepositoryInterfaceSignatureBuilder
extends AbstractPartialImplementationBuilder
implements DataRepositoryInterfaceSignatureBuilder {
    @Inject
    private DataRepositoryMethodSignatureBuilder dataRepositoryMethodSignatureBuilder;

    @Override
    public Set<DataRepositoryInterfaceSignature> build(EnvironmentContext environmentContext, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashSet<DataRepositoryInterfaceSignature> result = new HashSet<DataRepositoryInterfaceSignature>();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                this.validateInterfaceType(element, this.getRepositoryMarkerAnnotationClass(), "Repository");
                TypeElement repositoryInterface = (TypeElement)element;
                if (!environmentContext.isRxMicroClassShouldBeProcessed(repositoryInterface)) continue;
                try {
                    result.add(this.build(environmentContext, repositoryInterface));
                }
                catch (InterruptProcessingException e) {
                    this.error(e);
                }
            }
        }
        return result;
    }

    protected abstract Class<? extends Annotation> getRepositoryMarkerAnnotationClass();

    private DataRepositoryInterfaceSignature build(EnvironmentContext environmentContext, TypeElement restClientInterface) {
        Map.Entry overriddenMethodCandidates = this.getOverriddenMethodCandidates(restClientInterface);
        return new DataRepositoryInterfaceSignature(restClientInterface, (TypeElement)overriddenMethodCandidates.getKey(), this.dataRepositoryMethodSignatureBuilder.build(environmentContext, restClientInterface, overriddenMethodCandidates));
    }
}

