/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.data.sql.component.SQLFieldsOrderExtractor;
import io.rxmicro.annotation.processor.data.sql.model.SelectedColumn;
import io.rxmicro.annotation.processor.data.sql.model.SelectedColumnFilter;
import io.rxmicro.annotation.processor.data.sql.util.SQLs;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;

@Singleton
public final class SQLFieldsOrderExtractorImpl
implements SQLFieldsOrderExtractor {
    @Override
    public List<SelectedColumn> getSelectedColumns(List<String> sqlTokens, SelectedColumnFilter selectedColumnFilter) {
        ArrayList<SelectedColumn> result = new ArrayList<SelectedColumn>();
        ListIterator<String> iterator = sqlTokens.listIterator(selectedColumnFilter.getStartIndex());
        ArrayList<String> columnTokens = new ArrayList<String>();
        int parenthesesCount = 0;
        int bracesCount = 0;
        int bracketsCount = 0;
        while (iterator.hasNext()) {
            String token = (String)iterator.next();
            if (selectedColumnFilter.getIgnoredTokens().contains(token.toUpperCase(Locale.ENGLISH))) continue;
            if (parenthesesCount == 0 && bracesCount == 0 && bracketsCount == 0 && selectedColumnFilter.getBreakTokens().contains(token.toUpperCase(Locale.ENGLISH))) break;
            if ("(".equals(token)) {
                ++parenthesesCount;
            } else if (")".equals(token)) {
                --parenthesesCount;
            } else if ("{".equals(token)) {
                ++bracesCount;
            } else if ("}".equals(token)) {
                --bracesCount;
            } else if ("[".equals(token)) {
                ++bracketsCount;
            } else if ("]".equals(token)) {
                --bracketsCount;
            } else if (",".equals(token) && parenthesesCount == 0 && bracesCount == 0 && bracketsCount == 0) {
                this.addColumnTokensToResult(result, columnTokens);
                continue;
            }
            columnTokens.add(token);
        }
        this.addColumnTokensToResult(result, columnTokens);
        return result;
    }

    private void addColumnTokensToResult(List<SelectedColumn> result, List<String> columnTokens) {
        if (!columnTokens.isEmpty()) {
            result.add(this.build(columnTokens));
            columnTokens.clear();
        }
    }

    private SelectedColumn build(List<String> columnTokens) {
        if (columnTokens.size() == 1) {
            return SelectedColumn.buildColumn(columnTokens.get(0));
        }
        if ("AS".equalsIgnoreCase(columnTokens.get(columnTokens.size() - 2))) {
            String alias = columnTokens.get(columnTokens.size() - 1);
            List<String> expressions = columnTokens.size() > 2 ? columnTokens.subList(0, columnTokens.size() - 2) : List.of();
            return SelectedColumn.buildExpressionWithAlias(SQLs.joinTokensToSQL(expressions), alias);
        }
        if (columnTokens.size() == 3 && ".".equals(columnTokens.get(1))) {
            return SelectedColumn.buildExpressionWithAlias(SQLs.joinTokensToSQL(columnTokens), columnTokens.get(2));
        }
        return SelectedColumn.buildExpression(SQLs.joinTokensToSQL(columnTokens));
    }
}

