/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.model;

import io.rxmicro.common.util.Requires;
import java.util.Optional;

public final class SelectedColumn {
    private final String caption;
    private final String expression;

    public static SelectedColumn buildColumn(String columnName) {
        return new SelectedColumn((String)Requires.require((Object)columnName), columnName);
    }

    public static SelectedColumn buildExpression(String expression) {
        return new SelectedColumn(null, (String)Requires.require((Object)expression));
    }

    public static SelectedColumn buildExpressionWithAlias(String expression, String alias) {
        return new SelectedColumn((String)Requires.require((Object)alias), (String)Requires.require((Object)expression));
    }

    private SelectedColumn(String caption, String expression) {
        this.caption = caption;
        this.expression = expression;
    }

    public Optional<String> getCaption() {
        return Optional.ofNullable(this.caption);
    }

    public String getExpression() {
        return this.expression;
    }

    public String toString() {
        if (this.expression.equals(this.caption)) {
            return this.caption;
        }
        if (this.caption == null) {
            return this.expression;
        }
        return this.expression + " AS " + this.caption;
    }
}

