/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.component.impl.builder.select.operator;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.annotation.processor.data.sql.component.impl.builder.select.SelectSQLOperatorReader;
import io.rxmicro.common.util.Formats;
import io.rxmicro.data.sql.detail.SQLParams;
import java.util.List;
import java.util.ListIterator;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

@Singleton
public class INSelectSQLOperatorReader
implements SelectSQLOperatorReader {
    @Override
    public boolean canRead(String token) {
        return "IN".equalsIgnoreCase(token);
    }

    @Override
    public void read(ClassHeader.Builder classHeaderBuilder, ListIterator<String> iterator, List<Variable> methodParams, List<String> formatParams) {
        boolean isOpenParenthesesFound = false;
        while (iterator.hasNext()) {
            String token = iterator.next();
            if (Formats.FORMAT_PLACEHOLDER_TOKEN.equals(token)) {
                if (!isOpenParenthesesFound) {
                    iterator.previous();
                    iterator.add("(");
                    iterator.next();
                    iterator.add(")");
                }
                Variable variable = methodParams.remove(0);
                formatParams.add(this.resolveParameter(classHeaderBuilder, variable));
                continue;
            }
            if (!"(".equals(token)) {
                iterator.previous();
                break;
            }
            isOpenParenthesesFound = true;
        }
    }

    private String resolveParameter(ClassHeader.Builder classHeaderBuilder, Variable variable) {
        if (List.class.getName().equals(ProcessingEnvironmentHelper.getTypes().erasure(variable.getType()).toString())) {
            TypeMirror itemType = ((DeclaredType)variable.getType()).getTypeArguments().get(0);
            if (String.class.getName().equals(itemType.toString())) {
                classHeaderBuilder.addStaticImport(SQLParams.class, "joinStringParams");
                return Formats.format((String)"joinStringParams(?)", (Object[])new Object[]{variable.getName()});
            }
            return Elements.asEnumElement((TypeMirror)itemType).map(e -> {
                classHeaderBuilder.addStaticImport(SQLParams.class, "joinEnumParams");
                return Formats.format((String)"joinEnumParams(?)", (Object[])new Object[]{variable.getName()});
            }).orElseGet(() -> {
                classHeaderBuilder.addStaticImport(SQLParams.class, "joinParams");
                return Formats.format((String)"joinParams(?)", (Object[])new Object[]{variable.getName()});
            });
        }
        if (String.class.getName().equals(variable.getType().toString())) {
            return Formats.format((String)"\"'\" + ? + \"'\"", (Object[])new Object[]{variable.getName()});
        }
        return Elements.asEnumElement((TypeMirror)variable.getType()).map(e -> Formats.format((String)"\"'\" + ?.name() + \"'\"", (Object[])new Object[]{variable.getName()})).orElseGet(() -> ((Variable)variable).getName());
    }
}

