/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.data.sql.model.DbObjectName;
import io.rxmicro.common.util.Strings;
import io.rxmicro.data.sql.EnumType;
import io.rxmicro.data.sql.Schema;
import io.rxmicro.data.sql.Table;
import io.rxmicro.model.MappingStrategy;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@Singleton
public final class DbObjectNameBuilder {
    public DbObjectName buildTableName(TypeElement modelTypeElement) {
        final Table table = Optional.ofNullable(modelTypeElement.getAnnotation(Table.class)).orElseGet(() -> (Table)Annotations.defaultAnnotationInstance(Table.class));
        return this.build(modelTypeElement, new NameConfigurator(){

            @Override
            public String schema() {
                return table.schema();
            }

            @Override
            public String name() {
                return table.name();
            }

            @Override
            public MappingStrategy mappingStrategy() {
                return table.mappingStrategy();
            }

            @Override
            public String type() {
                return "table";
            }
        });
    }

    public DbObjectName buildEnumName(TypeElement modelTypeElement) {
        final EnumType enumType = Optional.ofNullable(modelTypeElement.getAnnotation(EnumType.class)).orElseGet(() -> (EnumType)Annotations.defaultAnnotationInstance(EnumType.class));
        return this.build(modelTypeElement, new NameConfigurator(){

            @Override
            public String schema() {
                return enumType.schema();
            }

            @Override
            public String name() {
                return enumType.name();
            }

            @Override
            public MappingStrategy mappingStrategy() {
                return enumType.mappingStrategy();
            }

            @Override
            public String type() {
                return "enum";
            }
        });
    }

    private DbObjectName build(TypeElement modelTypeElement, NameConfigurator nameConfigurator) {
        String className = modelTypeElement.getSimpleName().toString();
        List classNameWords = Strings.splitByCamelCase((String)className);
        String dbObjectName = Optional.of(nameConfigurator.name()).filter(v -> !v.isEmpty()).orElseGet(() -> nameConfigurator.mappingStrategy().getModelName(classNameWords));
        Optional<String> schemaOptional = this.getSchema(nameConfigurator.schema(), modelTypeElement);
        if (schemaOptional.isPresent()) {
            if (dbObjectName.contains(".")) {
                throw new InterruptProcessingException((Element)modelTypeElement, "? name already contains a schema name. Remove the schema definition!", new Object[]{Strings.capitalize((String)nameConfigurator.type())});
            }
            return new DbObjectName(schemaOptional.get(), dbObjectName);
        }
        if (dbObjectName.contains(".")) {
            String[] names = dbObjectName.split("\\.");
            if (names.length != 2) {
                throw new InterruptProcessingException((Element)modelTypeElement, "Invalid ? name: '?'. Set a valid name!", new Object[]{nameConfigurator.type(), dbObjectName});
            }
            return new DbObjectName(names[0], names[1]);
        }
        return new DbObjectName(dbObjectName);
    }

    private Optional<String> getSchema(String dbObjectSchema, TypeElement modelTypeElement) {
        Schema schemaAnnotation = modelTypeElement.getAnnotation(Schema.class);
        if (schemaAnnotation != null) {
            if (schemaAnnotation.value().isEmpty()) {
                throw new InterruptProcessingException((Element)modelTypeElement, "Redundant annotation: '?'. Remote it", new Object[]{Schema.class.getName()});
            }
            if (!dbObjectSchema.isEmpty()) {
                throw new InterruptProcessingException((Element)modelTypeElement, "Redundant annotation: '?'. Remote it", new Object[]{Schema.class.getName()});
            }
            return Optional.of(schemaAnnotation.value());
        }
        return Optional.of(dbObjectSchema).filter(v -> !v.isEmpty());
    }

    private static interface NameConfigurator {
        public String schema();

        public String name();

        public MappingStrategy mappingStrategy();

        public String type();
    }
}

