/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataObjectModelClass;
import io.rxmicro.annotation.processor.data.sql.model.SelectedColumn;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

@Singleton
public final class SQLFieldsOrderValidator {
    public void validateSelectedColumn(ExecutableElement method, SQLDataObjectModelClass<?> modelClass, List<String> defaultColumns, List<SelectedColumn> actualColumns) {
        HashSet<String> uniqueColumns = new HashSet<String>();
        for (int i = 0; i < actualColumns.size(); ++i) {
            SelectedColumn column = actualColumns.get(i);
            Optional<String> optionalCaption = column.getCaption();
            if (optionalCaption.isEmpty()) {
                throw this.missingAliasException(method, i, column);
            }
            String actualCaption = optionalCaption.get();
            if (!defaultColumns.contains(actualCaption)) {
                throw this.unmappingColumnError(method, modelClass, actualCaption);
            }
            this.validateUniqueColumnName(method, uniqueColumns, actualCaption, column.toString());
        }
    }

    public void validateSelectedColumn(ExecutableElement method, List<SelectedColumn> actualColumns) {
        HashSet<String> uniqueColumns = new HashSet<String>();
        for (int i = 0; i < actualColumns.size(); ++i) {
            SelectedColumn column = actualColumns.get(i);
            Optional<String> optionalCaption = column.getCaption();
            if (optionalCaption.isEmpty()) {
                throw this.missingAliasException(method, i, column);
            }
            String actualCaption = optionalCaption.get();
            this.validateUniqueColumnName(method, uniqueColumns, actualCaption, column.toString());
        }
    }

    public void validateStringColumns(ExecutableElement method, SQLDataObjectModelClass<?> modelClass, List<String> defaultColumns, List<String> actualColumns) {
        HashSet<String> uniqueColumns = new HashSet<String>();
        for (String column : actualColumns) {
            if (!defaultColumns.contains(column)) {
                throw this.unmappingColumnError(method, modelClass, column);
            }
            this.validateUniqueColumnName(method, uniqueColumns, column, column);
        }
    }

    private InterruptProcessingException missingAliasException(ExecutableElement method, int index, SelectedColumn column) {
        return new InterruptProcessingException((Element)method, "Missing alias for expression: Index=? (Zero based), Expression='?'. Add column alias!", new Object[]{index, column.getExpression()});
    }

    private InterruptProcessingException unmappingColumnError(ExecutableElement method, SQLDataObjectModelClass<?> modelClass, String actualCaption) {
        return new InterruptProcessingException((Element)method, "Selected column does not map to any entity field. Column='?', Entity class='?'. Remove the column from select fields or add appropriate entity field!", new Object[]{actualCaption, modelClass.getModelTypeElement().getQualifiedName()});
    }

    private void validateUniqueColumnName(ExecutableElement method, Set<String> uniqueColumns, String actualCaption, String columnExpression) {
        if (!uniqueColumns.add(actualCaption)) {
            throw new InterruptProcessingException((Element)method, "Detected duplicate of column or alias in select field list: '?'. Remove the duplicate!", new Object[]{columnExpression});
        }
    }
}

