/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.model;

import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SQLVariableValue {
    private static final String VALUE_VAR = "${VALUE-VAR}";
    private final List<String> columns;
    private final List<String> itemTemplate;
    private final String delimiter;

    public static SQLVariableValue createColumnList(List<String> columns) {
        return new SQLVariableValue(columns, List.of(VALUE_VAR), ",");
    }

    public static SQLVariableValue createValues(List<String> values) {
        return new SQLVariableValue(values, List.of(VALUE_VAR), ",");
    }

    public static SQLVariableValue createSetColumnList(List<String> columns) {
        return new SQLVariableValue(columns, List.of(VALUE_VAR, "=", Formats.FORMAT_PLACEHOLDER_TOKEN), ",");
    }

    public static SQLVariableValue createSetColumnListUsingPseudoTable(List<String> columns, String pseudoTableName) {
        return new SQLVariableValue(columns, List.of(VALUE_VAR, "=", pseudoTableName + ".${VALUE-VAR}"), ",");
    }

    public static SQLVariableValue createByIdFilter(List<String> columns) {
        return new SQLVariableValue(columns, List.of(VALUE_VAR, "=", Formats.FORMAT_PLACEHOLDER_TOKEN), "AND");
    }

    private SQLVariableValue(List<String> columns, List<String> itemTemplate, String delimiter) {
        this.columns = (List)Requires.require(columns);
        this.itemTemplate = (List)Requires.require(itemTemplate);
        this.delimiter = (String)Requires.require((Object)delimiter);
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<String> getSQLTokens() {
        return this.columns.stream().flatMap(column -> Stream.concat(Stream.of(this.delimiter), this.itemTemplate.stream().map(v -> this.convertItem((String)column, (String)v)))).skip(1L).collect(Collectors.toList());
    }

    private String convertItem(String column, String value) {
        if (VALUE_VAR.equals(value)) {
            return column;
        }
        if (value.contains(VALUE_VAR)) {
            return value.replace(VALUE_VAR, column);
        }
        return value;
    }
}

