/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.component.impl.builder;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.common.component.impl.AbstractProcessorComponent;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.annotation.processor.data.sql.component.PlatformPlaceholders;
import io.rxmicro.annotation.processor.data.sql.component.impl.builder.select.SelectSQLOperatorReader;
import io.rxmicro.annotation.processor.data.sql.model.BindParameter;
import io.rxmicro.annotation.processor.data.sql.model.PlatformPlaceholderGenerator;
import io.rxmicro.annotation.processor.data.sql.model.VariableValuesMap;
import io.rxmicro.common.util.Formats;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public abstract class AbstractSQLBuilder
extends AbstractProcessorComponent {
    @Inject
    private Set<SelectSQLOperatorReader> selectSQLOperatorReaders;
    @Inject
    private PlatformPlaceholders platformPlaceHolders;

    protected void validateSupportedVars(Class<? extends Annotation> annotationClass, ExecutableElement method, Iterable<String> vars, Set<String> supportedSelectVariableNames, Set<String> extVariables, String ... additionalVariables) {
        Set set = Stream.of(supportedSelectVariableNames.stream(), extVariables.stream(), Arrays.stream(additionalVariables)).flatMap(Function.identity()).collect(Collectors.toSet());
        for (String var : vars) {
            if (set.contains(var)) continue;
            throw new InterruptProcessingException((Element)method, "Unsupported @? variables: '?'. Supported variables are: ?", new Object[]{annotationClass.getSimpleName(), var, supportedSelectVariableNames});
        }
    }

    protected final Set<String> extractVariables(ExecutableElement method, List<String> sqlTokens, List<String> extraVarNames) {
        return sqlTokens.stream().filter(token -> extraVarNames.contains(token) || token.startsWith("${")).peek(token -> {
            if (token.startsWith("${") && !token.endsWith("}")) {
                throw new InterruptProcessingException((Element)method, "Missing '}' for variable: ?", new Object[]{token.substring(2)});
            }
        }).collect(Collectors.toSet());
    }

    protected final void setVariableValues(ExecutableElement method, List<String> sqlTokens, Set<String> vars, VariableValuesMap variableValuesMap) {
        if (!vars.isEmpty()) {
            HashSet<String> removableVars = new HashSet<String>(vars);
            int index = 0;
            while (index < sqlTokens.size()) {
                String token = sqlTokens.get(index);
                if ("*".equals(token) && this.shouldAsteriskBeIgnored(index, sqlTokens)) {
                    ++index;
                    continue;
                }
                if (vars.contains(token)) {
                    removableVars.remove(token);
                    if (variableValuesMap.isStringValue(token)) {
                        sqlTokens.set(index, variableValuesMap.getString(token));
                    } else if (variableValuesMap.isSqlVariableValue(token)) {
                        sqlTokens.remove(index);
                        List<String> tokens = variableValuesMap.getSqlVariableValue(token).getSQLTokens();
                        sqlTokens.addAll(index, tokens);
                        index += tokens.size();
                    } else {
                        throw new InterruptProcessingException((Element)method, "Variable '?' couldn't be resolved. Remove this variable or add missing config param.", new Object[]{token});
                    }
                }
                ++index;
            }
            removableVars.remove("*");
            if (!removableVars.isEmpty()) {
                throw new InterruptProcessingException((Element)method, "Variable(s) couldn't be resolved: '?'. Remote it or configure missing components!", new Object[]{removableVars});
            }
        }
    }

    protected abstract boolean shouldAsteriskBeIgnored(int var1, List<String> var2);

    protected final void validatePlaceholderCount(ExecutableElement method, List<String> sqlTokens, List<?> methodParams) {
        long methodParamSize;
        long placeholderCount = sqlTokens.stream().filter(Formats.FORMAT_PLACEHOLDER_TOKEN::equals).count();
        if (placeholderCount < (methodParamSize = (long)methodParams.size())) {
            throw new InterruptProcessingException((Element)method, "Missing param placeholder(s): Expected ?, but actual is ?", new Object[]{methodParamSize, placeholderCount});
        }
        if (placeholderCount > methodParamSize) {
            throw new InterruptProcessingException((Element)method, "Redundant param placeholder(s): Expected ?, but actual is ?", new Object[]{methodParamSize, placeholderCount});
        }
    }

    protected final void replaceAllPlaceholders(List<String> sqlTokens) {
        PlatformPlaceholderGenerator platformPlaceholderGenerator = this.platformPlaceHolders.createPlatformPlaceholderGenerator();
        for (int i = 0; i < sqlTokens.size(); ++i) {
            if (!Formats.FORMAT_PLACEHOLDER_TOKEN.equals(sqlTokens.get(i))) continue;
            sqlTokens.set(i, platformPlaceholderGenerator.getNextPlaceHolder());
        }
    }

    protected final void splitParams(Element owner, ClassHeader.Builder classHeaderBuilder, List<String> sqlTokens, List<Variable> methodParams, List<String> formatParams, List<BindParameter> bindParams) {
        ArrayList<Variable> methodParamsCopy = new ArrayList<Variable>(methodParams);
        PlatformPlaceholderGenerator platformPlaceholderGenerator = this.platformPlaceHolders.createPlatformPlaceholderGenerator();
        ListIterator<String> iterator = sqlTokens.listIterator();
        while (iterator.hasNext()) {
            String token = iterator.next();
            for (SelectSQLOperatorReader reader : this.selectSQLOperatorReaders) {
                if (!reader.canRead(token)) continue;
                reader.read(classHeaderBuilder, iterator, methodParamsCopy, formatParams);
                break;
            }
            if (!Formats.FORMAT_PLACEHOLDER_TOKEN.equals(token)) continue;
            if (methodParamsCopy.isEmpty()) {
                throw new InterruptProcessingException(owner, "Redundant '?' placeholder! Remove it!", new Object[0]);
            }
            iterator.set(platformPlaceholderGenerator.getNextPlaceHolder());
            Variable variable = methodParamsCopy.remove(0);
            bindParams.add(new BindParameter(variable, variable.getGetter()));
        }
    }
}

