/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.model;

import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.data.model.DataObjectModelClass;
import io.rxmicro.annotation.processor.data.sql.model.EntityFromDBConverterMethod;
import io.rxmicro.annotation.processor.data.sql.model.EntitySetFieldsConverterMethod;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataModelField;
import io.rxmicro.common.util.ExCollectors;
import io.rxmicro.data.sql.NotInsertable;
import io.rxmicro.data.sql.NotUpdatable;
import io.rxmicro.data.sql.PrimaryKey;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public abstract class SQLDataObjectModelClass<DMF extends SQLDataModelField>
extends DataObjectModelClass<DMF> {
    private final Set<EntityFromDBConverterMethod> entityFromDBConverterMethods = new TreeSet<EntityFromDBConverterMethod>();
    private final Set<EntitySetFieldsConverterMethod> entitySetFieldsConverterMethods = new TreeSet<EntitySetFieldsConverterMethod>();
    private Set<Map.Entry<DMF, ModelClass>> insertableParams;
    private Set<Map.Entry<DMF, ModelClass>> updatableParams;
    private Set<Map.Entry<DMF, ModelClass>> primaryKeysParams;
    private boolean insertable;
    private boolean updatable;
    private boolean deletable;

    public SQLDataObjectModelClass(TypeMirror modelTypeMirror, TypeElement modelTypeElement, Map<DMF, ModelClass> params) {
        super(modelTypeMirror, modelTypeElement, params);
    }

    public Set<EntityFromDBConverterMethod> getEntityFromDBConverterMethods() {
        return Collections.unmodifiableSet(this.entityFromDBConverterMethods);
    }

    public void addEntityFromDBConverterMethod(EntityFromDBConverterMethod method) {
        this.entityFromDBConverterMethods.add(method);
    }

    public Set<EntitySetFieldsConverterMethod> getEntitySetFieldsConverterMethods() {
        return Collections.unmodifiableSet(this.entitySetFieldsConverterMethods);
    }

    public void addEntitySetFieldsConverterMethod(EntitySetFieldsConverterMethod method) {
        this.entitySetFieldsConverterMethods.add(method);
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public Set<Map.Entry<DMF, ModelClass>> getInsertableParams() {
        if (this.insertableParams == null) {
            this.insertableParams = (Set)this.getParamEntries().stream().filter(e -> ((SQLDataModelField)((Object)((Object)e.getKey()))).getAnnotation(NotInsertable.class) == null).collect(ExCollectors.toOrderedSet());
        }
        return this.insertableParams;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public Set<Map.Entry<DMF, ModelClass>> getUpdatableParams() {
        if (this.updatableParams == null) {
            this.updatableParams = (Set)this.getParamEntries().stream().filter(e -> ((SQLDataModelField)((Object)((Object)e.getKey()))).getAnnotation(NotUpdatable.class) == null && ((SQLDataModelField)((Object)((Object)e.getKey()))).getAnnotation(PrimaryKey.class) == null).collect(ExCollectors.toOrderedSet());
        }
        return this.updatableParams;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    public boolean isPrimaryKeysPresent() {
        return !this.getPrimaryKeysParams().isEmpty();
    }

    public Set<Map.Entry<DMF, ModelClass>> getPrimaryKeysParams() {
        if (this.primaryKeysParams == null) {
            this.primaryKeysParams = (Set)this.getParamEntries().stream().filter(e -> ((SQLDataModelField)((Object)((Object)e.getKey()))).getAnnotation(PrimaryKey.class) != null).collect(ExCollectors.toOrderedSet());
        }
        return this.primaryKeysParams;
    }
}

