/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.model;

import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import java.util.Optional;

public final class DbObjectName {
    private final String schema;
    private final String name;

    public DbObjectName(String schema, String name) {
        this.schema = (String)Requires.require((Object)schema);
        this.name = (String)Requires.require((Object)name);
    }

    public DbObjectName(String name) {
        this.schema = null;
        this.name = (String)Requires.require((Object)name);
    }

    public String getFullName() {
        if (this.schema == null) {
            return this.name;
        }
        return Formats.format((String)"?.?", (Object[])new Object[]{this.schema, this.name});
    }

    public String getSimpleName() {
        return this.name;
    }

    public Optional<String> getSchema() {
        return Optional.ofNullable(this.schema);
    }
}

