/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.util;

import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class SQLs {
    private static final Set<String> ADD_SPACE_AFTER_TOKENS_BEFORE_PARENTHESES = Set.of("IN", "WHERE", ",");

    public static String joinTokensToSQL(List<String> sqlTokens) {
        StringBuilder sql = new StringBuilder();
        String prevToken = null;
        for (String token : sqlTokens) {
            if (sql.length() == 0) {
                sql.append(SQLs.escape(token));
            } else if (".".equals(token) || ",".equals(token) || ")".equals(token) || "]".equals(token) || "}".equals(token)) {
                sql.append(token);
            } else if ("(".equals(token)) {
                if (ADD_SPACE_AFTER_TOKENS_BEFORE_PARENTHESES.contains(prevToken)) {
                    sql.append(' ');
                }
                sql.append(SQLs.escape(token));
            } else {
                char lastChar = sql.charAt(sql.length() - 1);
                if (lastChar != '(' && lastChar != '[' && lastChar != '{' && lastChar != '.') {
                    sql.append(' ');
                }
                sql.append(SQLs.escape(token));
            }
            prevToken = token.toUpperCase(Locale.ENGLISH);
        }
        return sql.toString();
    }

    private static String escape(String token) {
        return token.replace("\"", "\\\"");
    }

    private SQLs() {
    }
}

