/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.component.impl.resolver;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.common.component.ModelFieldBuilder;
import io.rxmicro.annotation.processor.common.model.ModelFieldType;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.data.sql.component.SQLVariableValueResolver;
import io.rxmicro.annotation.processor.data.sql.component.impl.TableContextBuilder;
import io.rxmicro.annotation.processor.data.sql.component.impl.resolver.SQLVariableValueCalculatorProvider;
import io.rxmicro.annotation.processor.data.sql.model.ModelClassSupplier;
import io.rxmicro.annotation.processor.data.sql.model.ParsedSQL;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataModelField;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataObjectModelClass;
import io.rxmicro.annotation.processor.data.sql.model.SQLMethodDescriptor;
import io.rxmicro.annotation.processor.data.sql.model.TableContext;
import io.rxmicro.annotation.processor.data.sql.model.VariableContext;
import io.rxmicro.annotation.processor.data.sql.model.VariableValuesMap;
import io.rxmicro.common.util.Formats;
import io.rxmicro.data.sql.VariableValues;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public abstract class AbstractSQLVariableValueResolver<A extends Annotation, DMF extends SQLDataModelField, DMC extends SQLDataObjectModelClass<DMF>>
implements SQLVariableValueResolver<A, DMF, DMC> {
    private final Map<TypeElement, DMC> modelClassesCache = new HashMap<TypeElement, DMC>();
    @Inject
    private ModelFieldBuilder<DMF, DMC> modelFieldModelFieldBuilder;
    @Inject
    private TableContextBuilder tableContextBuilder;

    @Override
    public final VariableValuesMap resolveVariableValues(VariableContext variableContext, ParsedSQL<A> parsedSQL, ExecutableElement method, SQLMethodDescriptor<DMF, DMC> sqlMethodDescriptor) {
        List<Supplier<ModelClassSupplier<DMF, DMC>>> modelClassSuppliers = this.getModelClassSuppliers(parsedSQL, sqlMethodDescriptor);
        VariableValuesMap globalVariableValuesMap = new VariableValuesMap();
        VariableValuesMap localVariableValuesMap = new VariableValuesMap();
        VariableValuesMap entityVariableValuesMap = new VariableValuesMap();
        Optional.ofNullable(method.getEnclosingElement().getAnnotation(VariableValues.class)).map(VariableValues::value).ifPresent(v -> this.setVariables(method.getEnclosingElement(), globalVariableValuesMap, (String)v));
        Iterator<Supplier<ModelClassSupplier<DMF, DMC>>> iterator = modelClassSuppliers.iterator();
        if (iterator.hasNext()) {
            Supplier<ModelClassSupplier<DMF, DMC>> modelClassSupplier = iterator.next();
            DMC modelClass = modelClassSupplier.get().getModelClass();
            TableContext tableContext = this.tableContextBuilder.createTableContext(modelClass.getModelTypeElement());
            variableContext.setCurrentTable(tableContext);
            this.putVariableValues(variableContext, entityVariableValuesMap, this.getSupportedVariables(), modelClass);
        }
        Optional.ofNullable(method.getAnnotation(VariableValues.class)).map(VariableValues::value).ifPresent(v -> this.setVariables(method, localVariableValuesMap, (String)v));
        this.throwErrorIfFound(method, iterator);
        variableContext.releaseCurrentTable();
        return this.mergeVariableValuesMaps(method, globalVariableValuesMap, localVariableValuesMap, entityVariableValuesMap);
    }

    private void throwErrorIfFound(ExecutableElement method, Iterator<Supplier<ModelClassSupplier<DMF, DMC>>> iterator) {
        while (iterator.hasNext()) {
            Supplier<ModelClassSupplier<DMF, DMC>> modelClassSupplier = iterator.next();
            modelClassSupplier.get().getUnUsedError().ifPresent(error -> {
                throw new InterruptProcessingException((Element)method, error, new Object[0]);
            });
        }
    }

    protected abstract Set<String> getSupportedVariables();

    private List<Supplier<ModelClassSupplier<DMF, DMC>>> getModelClassSuppliers(ParsedSQL<A> parsedSQL, SQLMethodDescriptor<DMF, DMC> sqlMethodDescriptor) {
        SQLDataObjectModelClass modelClass;
        ArrayList<Supplier<ModelClassSupplier<DMF, DMC>>> list = new ArrayList<Supplier<ModelClassSupplier<DMF, DMC>>>();
        if (this.isSupportEntityParam() && sqlMethodDescriptor.getEntityParam().isPresent()) {
            modelClass = (SQLDataObjectModelClass)((Object)sqlMethodDescriptor.getEntityParam().get());
            this.modelClassesCache.put(modelClass.getModelTypeElement(), (DMC)((Object)modelClass));
            list.add(() -> new ModelClassSupplier(modelClass));
        }
        if (this.isSupportEntityResult() && sqlMethodDescriptor.getEntityResult().isPresent()) {
            modelClass = (SQLDataObjectModelClass)((Object)sqlMethodDescriptor.getEntityResult().get());
            this.modelClassesCache.put(modelClass.getModelTypeElement(), (DMC)((Object)modelClass));
            list.add(() -> new ModelClassSupplier(modelClass));
        }
        Optional entityTypeElement = Annotations.getAnnotationClassParameter(() -> this.getEntityClass(parsedSQL));
        entityTypeElement.ifPresent(typeElement -> list.add(this.getCachedModelClassSupplier(parsedSQL, sqlMethodDescriptor, (TypeElement)typeElement)));
        return list;
    }

    private Supplier<ModelClassSupplier<DMF, DMC>> getCachedModelClassSupplier(ParsedSQL<A> parsedSQL, SQLMethodDescriptor<DMF, DMC> sqlMethodDescriptor, TypeElement typeElement) {
        return () -> {
            SQLDataObjectModelClass modelClass = this.modelClassesCache.computeIfAbsent(typeElement, t -> (SQLDataObjectModelClass)((Object)((Object)((Object)this.modelFieldModelFieldBuilder.build(ModelFieldType.UNDEFINED, sqlMethodDescriptor.getCurrentModule(), Set.of(t), false).get(t)))));
            return new ModelClassSupplier(modelClass, Formats.format((String)"@?.entityClass() is redundant annotation parameter. Current entity detected using method parameters or method result. Remove this parameter!", (Object[])new Object[]{parsedSQL.getAnnotation().annotationType().getSimpleName()}));
        };
    }

    protected boolean isSupportEntityParam() {
        return true;
    }

    protected boolean isSupportEntityResult() {
        return true;
    }

    protected abstract Class<?> getEntityClass(ParsedSQL<A> var1);

    private void setVariables(Element owner, VariableValuesMap variableValuesMap, String ... variables) {
        if (variables.length % 2 == 1) {
            throw new InterruptProcessingException(owner, "Variable values must contains even item count: key1, value1, key2, value2,...", new Object[0]);
        }
        for (int i = 0; i < variables.length; i += 2) {
            String variableName = variables[i];
            String variableValue = variables[i + 1];
            boolean alreadyExists = variableValuesMap.containsKey(variableName);
            if (alreadyExists) {
                throw new InterruptProcessingException(owner, "Variable definition '? = ?' is redundant. Remove it!", new Object[]{variableName, variableValue});
            }
            variableValuesMap.put(variableName, variableValue);
        }
    }

    private void putVariableValues(VariableContext variableContext, VariableValuesMap variableValuesMap, Set<String> variableNames, DMC modelClass) {
        for (String variableName : variableNames) {
            BiFunction<SQLDataObjectModelClass<? extends SQLDataModelField>, VariableContext, Object> provider = SQLVariableValueCalculatorProvider.VARIABLE_RESOLVER_PROVIDER.get(variableName);
            if (provider == null) {
                throw new InternalErrorException("Variable provider not found for variable: '?'", new Object[]{variableName});
            }
            variableValuesMap.put(variableName, provider.apply((SQLDataObjectModelClass<? extends SQLDataModelField>)((Object)modelClass), variableContext));
        }
    }

    private VariableValuesMap mergeVariableValuesMaps(ExecutableElement method, VariableValuesMap globalVariableValuesMap, VariableValuesMap localVariableValuesMap, VariableValuesMap entityVariableValuesMap) {
        localVariableValuesMap.forEach((k, v) -> {
            if (entityVariableValuesMap.containsKey(k)) {
                throw new InterruptProcessingException((Element)method, "Local variable definition '? = ?' is redundant. Remove it!", new Object[]{k, v});
            }
        });
        VariableValuesMap variableValuesMap = new VariableValuesMap(globalVariableValuesMap);
        localVariableValuesMap.forEach(variableValuesMap::put);
        entityVariableValuesMap.forEach(variableValuesMap::put);
        return variableValuesMap;
    }
}

