/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.component.impl;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.common.component.TokenParser;
import io.rxmicro.annotation.processor.common.model.TokenParserRule;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodBody;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.data.component.impl.AbstractDataRepositoryMethodModelBuilder;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.model.DataRepositoryMethodSignature;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.annotation.processor.data.sql.component.SQLRepositoryMethodModelBuilder;
import io.rxmicro.annotation.processor.data.sql.component.impl.TransactionResolver;
import io.rxmicro.annotation.processor.data.sql.model.ParsedSQL;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataModelField;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataObjectModelClass;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataRepositoryMethod;
import io.rxmicro.annotation.processor.data.sql.model.SQLMethodDescriptor;
import io.rxmicro.data.sql.model.EntityFieldList;
import io.rxmicro.data.sql.model.EntityFieldMap;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

public abstract class AbstractSQLDataRepositoryMethodModelBuilder<DMF extends SQLDataModelField, DMC extends SQLDataObjectModelClass<DMF>>
extends AbstractDataRepositoryMethodModelBuilder<DMF, SQLDataRepositoryMethod, DMC>
implements SQLRepositoryMethodModelBuilder<DMF, DMC> {
    @Inject
    private TransactionResolver transactionResolver;
    @Inject
    private TokenParser tokenParser;
    @Inject
    private TokenParserRule tokenParserRule;

    protected final SQLDataRepositoryMethod build(DataRepositoryMethodSignature dataRepositoryMethodSignature, MethodBody body) {
        return new SQLDataRepositoryMethod(dataRepositoryMethodSignature, body);
    }

    protected final SQLMethodDescriptor<DMF, DMC> buildSQLMethodDescriptor(ExecutableElement method, List<Variable> methodParams, MethodResult methodResult, DataGenerationContext<DMF, DMC> dataGenerationContext) {
        SQLMethodDescriptor.Builder builder = new SQLMethodDescriptor.Builder(dataGenerationContext.getCurrentModule(), methodParams, methodResult);
        methodParams.stream().flatMap(v -> Elements.asTypeElement((TypeMirror)v.getType()).flatMap(t -> Optional.ofNullable((SQLDataObjectModelClass)((Object)((Object)((Object)dataGenerationContext.getEntityParamMap().get(t)))))).stream()).forEach(modelClass -> {
            if (builder.isEntityParamSet()) {
                throw new InterruptProcessingException((Element)method, "Repository method does not support multi entity params. Remove param of type: ?", new Object[]{modelClass.getModelTypeElement().getQualifiedName()});
            }
            builder.setEntityParam(modelClass);
        });
        Elements.asTypeElement((TypeMirror)methodResult.getResultType()).flatMap(t -> Optional.ofNullable((SQLDataObjectModelClass)((Object)((Object)dataGenerationContext.getEntityReturnMap().get(t))))).ifPresent(builder::setEntityResult);
        SQLMethodDescriptor sqlMethodDescriptor = builder.build();
        this.validate(method, sqlMethodDescriptor);
        return sqlMethodDescriptor;
    }

    protected final <A extends Annotation> ParsedSQL<A> parseSQL(String sql, A annotation) {
        List sqlTokens = sql.isEmpty() ? List.of() : this.tokenParser.parse(sql, this.tokenParserRule, false).getTokens();
        return new ParsedSQL<A>(annotation, sqlTokens);
    }

    protected final boolean isEntityParam(List<Variable> params, DataGenerationContext<DMF, DMC> dataGenerationContext) {
        if (params.size() != 1) {
            return false;
        }
        return dataGenerationContext.isEntityParamType(params.get(0).getType());
    }

    protected final void validateThatEntityContainsPrimaryKeyIfCurrentParamIsEntity(DataGenerationContext<DMF, DMC> dataGenerationContext, ExecutableElement method, List<Variable> params) {
        SQLDataObjectModelClass modelClass;
        boolean isEntityParam = this.isEntityParam(params, dataGenerationContext);
        if (isEntityParam && (modelClass = (SQLDataObjectModelClass)((Object)dataGenerationContext.getEntityParamMap().get(Elements.asTypeElement((TypeMirror)params.get(0).getType()).orElseThrow()))).getPrimaryKeysParams().isEmpty()) {
            throw new InterruptProcessingException((Element)method, "Can't generate method body, because '?' entity class does not contain primary keys!", new Object[]{params.get(0).getType()});
        }
    }

    protected boolean isEntityResultReturn(DataGenerationContext<DMF, DMC> dataGenerationContext, MethodResult methodResult) {
        return dataGenerationContext.isEntityResultType(methodResult.getResultType()) || dataGenerationContext.isEntityParamType(methodResult.getResultType()) || methodResult.isResultType(EntityFieldList.class) || methodResult.isResultType(EntityFieldMap.class);
    }

    protected final Optional<String> getTransactionMethodParameter(ExecutableElement method) {
        return this.transactionResolver.getTransactionParameter(method).map(Variable::getGetter);
    }

    private void validate(ExecutableElement method, SQLMethodDescriptor<DMF, DMC> sqlMethodDescriptor) {
        if (sqlMethodDescriptor.getEntityParam().isPresent() && sqlMethodDescriptor.getParams().size() > 1) {
            throw new InterruptProcessingException((Element)method, "Repository method couldn't contain any parameters with entity parameter", new Object[0]);
        }
        if (sqlMethodDescriptor.getEntityParam().isPresent() && sqlMethodDescriptor.getEntityResult().isPresent() && !((SQLDataObjectModelClass)((Object)sqlMethodDescriptor.getEntityParam().get())).getJavaFullClassName().equals(((SQLDataObjectModelClass)((Object)sqlMethodDescriptor.getEntityResult().get())).getJavaFullClassName())) {
            throw new InterruptProcessingException((Element)method, "An entity parameter class must be equals to the entity result class", new Object[0]);
        }
    }
}

