/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.component.impl.builder.select.operator;

import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.data.model.Var;
import io.rxmicro.annotation.processor.data.sql.component.impl.builder.select.SelectSQLOperatorReader;
import io.rxmicro.common.util.Formats;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class OrderBySelectSQLOperatorReader
implements SelectSQLOperatorReader {
    private final Set<String> afterOrderKeywords;

    public OrderBySelectSQLOperatorReader(Set<String> afterOrderKeywords) {
        this.afterOrderKeywords = afterOrderKeywords;
    }

    @Override
    public boolean canRead(String token) {
        return "ORDER".equalsIgnoreCase(token);
    }

    @Override
    public void read(ClassHeader.Builder classHeaderBuilder, ListIterator<String> iterator, List<Var> methodParams, List<String> formatParams) {
        int nested = 0;
        while (iterator.hasNext()) {
            String token = iterator.next();
            if (this.afterOrderKeywords.contains(token.toUpperCase())) {
                return;
            }
            if (Formats.FORMAT_PLACEHOLDER_TOKEN.equals(token)) {
                formatParams.add(methodParams.remove(0).getGetter());
                continue;
            }
            if ("(".equals(token)) {
                ++nested;
                continue;
            }
            if (!")".equals(token)) continue;
            if (nested == 0) {
                return;
            }
            --nested;
        }
    }
}

