/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.component.impl.builder.select;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.data.model.Var;
import io.rxmicro.annotation.processor.data.sql.component.SQLVariableValueResolver;
import io.rxmicro.annotation.processor.data.sql.component.impl.SQLFieldsOrderValidator;
import io.rxmicro.annotation.processor.data.sql.model.ParsedSQL;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataModelField;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataObjectModelClass;
import io.rxmicro.annotation.processor.data.sql.model.SQLMethodDescriptor;
import io.rxmicro.annotation.processor.data.sql.model.SQLStatement;
import io.rxmicro.annotation.processor.data.sql.model.VariableContext;
import io.rxmicro.annotation.processor.data.sql.model.VariableValuesMap;
import io.rxmicro.common.util.Formats;
import io.rxmicro.data.sql.operation.CustomSelect;
import io.rxmicro.data.sql.operation.Select;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

@Singleton
public class CustomSelectSQLBuilder<DMF extends SQLDataModelField, DMC extends SQLDataObjectModelClass<DMF>> {
    @Inject
    private SQLVariableValueResolver<Select, DMF, DMC> selectSQLVariableValueResolver;
    @Inject
    private SQLFieldsOrderValidator sqlFieldsOrderValidator;
    @Inject
    private VariableContext variableContext;

    public SQLStatement buildCustomSQL(ParsedSQL<Select> parsedSQL, ExecutableElement method, SQLMethodDescriptor<DMF, DMC> sqlMethodDescriptor) {
        VariableElement customSQL = this.getCustomSQL(method);
        CustomSelect customSelect = customSQL.getAnnotation(CustomSelect.class);
        SQLStatement.Builder builder = new SQLStatement.Builder().setDefaultColumnOrder(true).setBindParams(sqlMethodDescriptor.getParams().stream().map(Var::getGetter).collect(Collectors.toList()));
        if (customSelect.supportUniversalPlaceholder()) {
            builder.setSqlExpression(Formats.format((String)"replaceUniversalPlaceholder(?)", (Object[])new Object[]{customSQL.getSimpleName().toString()}));
        } else {
            builder.setSqlExpression(customSQL.getSimpleName().toString());
        }
        this.setResultColumnsAndDefaultColumnOrder(builder, parsedSQL, method, sqlMethodDescriptor, customSelect);
        return builder.build();
    }

    private void setResultColumnsAndDefaultColumnOrder(SQLStatement.Builder builder, ParsedSQL<Select> parsedSQL, ExecutableElement method, SQLMethodDescriptor<DMF, DMC> sqlMethodDescriptor, CustomSelect customSelect) {
        Optional<DMC> entityResultOptional = sqlMethodDescriptor.getEntityResult();
        if (entityResultOptional.isPresent()) {
            SQLDataObjectModelClass modelClass = (SQLDataObjectModelClass)((Object)entityResultOptional.get());
            VariableValuesMap variableValuesMap = this.selectSQLVariableValueResolver.resolveVariableValues(this.variableContext, parsedSQL, method, sqlMethodDescriptor);
            List<String> defaultColumns = variableValuesMap.getSqlVariableValue("${all-columns}").getColumns();
            List<String> customColumns = List.of(customSelect.selectedColumns());
            if (customColumns.isEmpty()) {
                builder.setDefaultColumnOrder(true).setResultColumns(defaultColumns);
            } else {
                this.sqlFieldsOrderValidator.validateStringColumns(method, modelClass, defaultColumns, customColumns);
                builder.setDefaultColumnOrder(defaultColumns.equals(customColumns)).setResultColumns(customColumns);
            }
        } else if (customSelect.selectedColumns().length > 0) {
            throw new InterruptProcessingException((Element)method, "Selected columns for custom select is redundant. Remote it!", new Object[0]);
        }
    }

    private VariableElement getCustomSQL(ExecutableElement method) {
        List customSQLs = method.getParameters().stream().filter(v -> v.getAnnotation(CustomSelect.class) != null).collect(Collectors.toList());
        if (customSQLs.isEmpty()) {
            throw new InterruptProcessingException((Element)method, "Missing method parameter, annotated by '@?' annotation or missing 'SELECT' query, which must be defined via '@?' annotation", new Object[]{CustomSelect.class.getName(), Select.class.getName()});
        }
        if (customSQLs.size() > 1) {
            throw new InterruptProcessingException((Element)method, "Expected only one method parameter, annotated by '@?' annotation", new Object[]{CustomSelect.class.getName()});
        }
        return (VariableElement)customSQLs.get(0);
    }
}

