/*
 * Copyright (c) 2020. https://rxmicro.io
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.rxmicro.annotation.processor.data.sql.model;

import java.lang.annotation.Annotation;
import java.util.List;

import static io.rxmicro.common.util.ExCollections.unmodifiableList;
import static io.rxmicro.common.util.Requires.require;

/**
 * @author nedis
 * @link https://rxmicro.io
 * @since 0.1
 */
public final class ParsedSQL<T extends Annotation> {

    private final T annotation;

    private final List<String> sqlTokens;

    public ParsedSQL(final T annotation,
                     final List<String> sqlTokens) {
        this.annotation = require(annotation);
        this.sqlTokens = unmodifiableList(sqlTokens);
    }

    public T getAnnotation() {
        return annotation;
    }

    public List<String> getSqlTokens() {
        return sqlTokens;
    }

    public boolean doesNotContain(final String token) {
        return sqlTokens.stream().noneMatch(v -> v.equalsIgnoreCase(token));
    }
}
