/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.r2dbc.component.impl.method;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.model.DataMethodParams;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.annotation.processor.data.sql.model.ParsedSQL;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataModelField;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataObjectModelClass;
import io.rxmicro.annotation.processor.data.sql.model.SQLMethodDescriptor;
import io.rxmicro.annotation.processor.data.sql.model.SQLStatement;
import io.rxmicro.annotation.processor.data.sql.r2dbc.component.impl.AbstractSQLModificationOperationDataRepositoryMethodModelBuilder;
import io.rxmicro.data.sql.operation.Delete;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;

@Singleton
public class DeleteSQLRepositoryMethodModelBuilder<DMF extends SQLDataModelField, DMC extends SQLDataObjectModelClass<DMF>>
extends AbstractSQLModificationOperationDataRepositoryMethodModelBuilder<Delete, DMF, DMC> {
    @Override
    protected ParsedSQL<Delete> parseSQL(ExecutableElement method, DataMethodParams dataMethodParams) {
        Delete annotation = method.getAnnotation(Delete.class);
        String originalSQL = Optional.of(annotation.value()).filter(v -> !v.isEmpty()).orElse(dataMethodParams.getOtherParams().isEmpty() ? "DELETE FROM ${table}" : "DELETE FROM ${table} WHERE ${by-id-filter}");
        return this.parseSQL(originalSQL, (Annotation)annotation);
    }

    @Override
    protected String getTemplateName() {
        return "data/sql/r2dbc/method/$$SQLRepositoryDeleteMethodBodyTemplate.javaftl";
    }

    @Override
    protected void validateMethod(ParsedSQL<Delete> parsedSQL, MethodResult methodResult, DataGenerationContext<DMF, DMC> dataGenerationContext, ExecutableElement method, DataMethodParams dataMethodParams) {
        super.validateMethod(parsedSQL, methodResult, dataGenerationContext, method, dataMethodParams);
        this.validateThatEntityContainsPrimaryKeyIfParamIsEntity(dataGenerationContext, method, dataMethodParams.getOtherParams());
    }

    @Override
    protected void addEntityConverter(MethodResult methodResult, SQLMethodDescriptor<DMF, DMC> sqlMethodDescriptor, DataGenerationContext<DMF, DMC> dataGenerationContext, List<Variable> params, SQLStatement sqlStatement, Map<String, Object> templateArguments) {
        super.addEntityConverter(methodResult, sqlMethodDescriptor, dataGenerationContext, params, sqlStatement, templateArguments);
        sqlMethodDescriptor.getEntityParam().ifPresent(modelClass -> {
            modelClass.setDeletable(true);
            templateArguments.put("IS_PRIMARY_KEY_SIMPLE", modelClass.getPrimaryKeysParams().size() == 1);
        });
    }

    public Class<? extends Annotation> operationType() {
        return Delete.class;
    }
}

