/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.r2dbc.component.impl.method;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodBody;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.data.component.DataMethodParamsResolver;
import io.rxmicro.annotation.processor.data.model.CommonDataGroupRules;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.model.DataMethodParams;
import io.rxmicro.annotation.processor.data.model.DataRepositoryMethodSignature;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.annotation.processor.data.sql.component.impl.AbstractSQLDataRepositoryMethodModelBuilder;
import io.rxmicro.annotation.processor.data.sql.model.CommonSQLGroupRules;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataModelField;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataObjectModelClass;
import io.rxmicro.annotation.processor.data.sql.model.SQLMethodBody;
import io.rxmicro.data.DataRepositoryGeneratorConfig;
import io.rxmicro.data.sql.model.IsolationLevel;
import io.rxmicro.data.sql.model.TransactionType;
import io.rxmicro.data.sql.model.rxjava3.Transaction;
import io.rxmicro.logger.RequestIdSupplier;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import reactor.core.publisher.Mono;

@Singleton
public class BeginTransactionSQLRepositoryMethodModelBuilder<DMF extends SQLDataModelField, DMC extends SQLDataObjectModelClass<DMF>>
extends AbstractSQLDataRepositoryMethodModelBuilder<DMF, DMC> {
    private final Map<String, Predicate<VariableElement>> groupRules = Map.of("REQUEST_ID_SUPPLIER_GROUP", CommonDataGroupRules.REQUEST_ID_SUPPLIER_PREDICATE, "ISOLATION_LEVEL_GROUP", CommonSQLGroupRules.ISOLATION_LEVEL_PREDICATE);
    @Inject
    private DataMethodParamsResolver dataMethodParamsResolver;

    public boolean isSupported(DataRepositoryMethodSignature dataRepositoryMethodSignature, DataGenerationContext<DMF, DMC> dataGenerationContext) {
        return TransactionType.SUPPORTED_TRANSACTION_TYPES.stream().anyMatch(t -> dataRepositoryMethodSignature.getMethodResult().isResultType(t));
    }

    public Class<? extends Annotation> operationType() {
        return BeginTransaction.class;
    }

    protected MethodBody buildBody(ClassHeader.Builder classHeaderBuilder, ExecutableElement method, MethodResult methodResult, DataRepositoryGeneratorConfig dataRepositoryGeneratorConfig, DataGenerationContext<DMF, DMC> dataGenerationContext) {
        classHeaderBuilder.addImports(new Class[]{Mono.class});
        DataMethodParams dataMethodParams = this.dataMethodParamsResolver.resolve(method, this.groupRules);
        this.validateCommonDataMethodParams(method, dataMethodParams);
        TransactionType transactionType = TransactionType.byClassName((String)methodResult.getResultType().toString());
        this.validateRequiredSingleReturnType(method, methodResult);
        this.validateTransactionType(method, methodResult, transactionType);
        HashMap<String, Object> templateArguments = new HashMap<String, Object>();
        templateArguments.put("RETURN", methodResult);
        dataMethodParams.getSingleParamOfGroup("ISOLATION_LEVEL_GROUP").ifPresent(v -> templateArguments.put("ISOLATION_LEVEL", v));
        templateArguments.put("CONNECTION_CREATE_PARAM", dataMethodParams.getSingleParamOfGroup("REQUEST_ID_SUPPLIER_GROUP").map(Variable::getName).orElse(""));
        return new SQLMethodBody(this.methodBodyGenerator.generate("data/sql/r2dbc/method/$$SQLRepositoryCreateTransactionMethodBodyTemplate.javaftl", templateArguments));
    }

    private void validateCommonDataMethodParams(ExecutableElement method, DataMethodParams dataMethodParams) {
        List requestIdSupplierParams = dataMethodParams.getParamsOfGroup("REQUEST_ID_SUPPLIER_GROUP");
        if (requestIdSupplierParams.size() > 1) {
            throw new InterruptProcessingException(((Variable)requestIdSupplierParams.get(1)).getElement(), "Only one parameter of '?' type is allowed per method. Remove the redundant parameter(s): ?", new Object[]{RequestIdSupplier.class.getName(), requestIdSupplierParams.stream().skip(1L).map(Variable::getName).collect(Collectors.joining(", "))});
        }
        List isolationLevelParams = dataMethodParams.getParamsOfGroup("ISOLATION_LEVEL_GROUP");
        if (isolationLevelParams.size() > 1) {
            throw new InterruptProcessingException(((Variable)isolationLevelParams.get(1)).getElement(), "Only one parameter of '?' type is allowed per method. Remove the redundant parameter(s): ?", new Object[]{IsolationLevel.class.getName(), isolationLevelParams.stream().skip(1L).map(Variable::getName).collect(Collectors.joining(", "))});
        }
        Iterator iterator = dataMethodParams.getOtherParams().iterator();
        if (iterator.hasNext()) {
            Variable param = (Variable)iterator.next();
            throw new InterruptProcessingException((Element)method, "Unsupported method parameter: '?'. '?' method can contain only following types of parameters: ?! Remove unsupported parameter!", new Object[]{param.getName(), method.getSimpleName(), Set.of(IsolationLevel.class.getName(), RequestIdSupplier.class.getName())});
        }
    }

    private void validateTransactionType(ExecutableElement repositoryMethod, MethodResult methodResult, TransactionType transactionType) {
        if (methodResult.isMono()) {
            if (transactionType != TransactionType.REACTOR) {
                throw new InterruptProcessingException((Element)repositoryMethod, "Invalid transaction type: '?'! Use '?' instead!", new Object[]{methodResult.getResultType(), io.rxmicro.data.sql.model.reactor.Transaction.class.getName()});
            }
        } else if (methodResult.isSingle()) {
            if (transactionType != TransactionType.RX_JAVA_3) {
                throw new InterruptProcessingException((Element)repositoryMethod, "Invalid transaction type: '?'! Use '?' instead!", new Object[]{methodResult.getResultType(), Transaction.class.getName()});
            }
        } else if (methodResult.isFuture()) {
            if (transactionType != TransactionType.COMPLETABLE_FUTURE) {
                throw new InterruptProcessingException((Element)repositoryMethod, "Invalid transaction type: '?'! Use '?' instead!", new Object[]{methodResult.getResultType(), io.rxmicro.data.sql.model.completablefuture.Transaction.class.getName()});
            }
        } else {
            throw new InterruptProcessingException((Element)repositoryMethod, "Unsupported method result: ?", new Object[]{methodResult});
        }
    }

    private static @interface BeginTransaction {
    }
}

