/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.r2dbc.component.impl;

import io.reactivex.rxjava3.core.Flowable;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.common.util.Errors;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.model.DataMethodParams;
import io.rxmicro.annotation.processor.data.model.DataRepositoryMethodSignature;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.annotation.processor.data.sql.model.EntitySetFieldsConverterMethod;
import io.rxmicro.annotation.processor.data.sql.model.ParsedSQL;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataModelField;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataObjectModelClass;
import io.rxmicro.annotation.processor.data.sql.model.SQLMethodDescriptor;
import io.rxmicro.annotation.processor.data.sql.model.SQLStatement;
import io.rxmicro.annotation.processor.data.sql.r2dbc.component.impl.AbstractSQLOperationDataRepositoryMethodModelBuilder;
import io.rxmicro.data.sql.ExpectedUpdatedRowsCount;
import io.rxmicro.data.sql.model.EntityFieldList;
import io.rxmicro.data.sql.model.EntityFieldMap;
import io.rxmicro.data.sql.operation.CustomSelect;
import io.rxmicro.data.sql.r2dbc.detail.EntityFromR2DBCSQLDBConverter;
import io.rxmicro.data.sql.r2dbc.detail.EntityToR2DBCSQLDBConverter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractSQLModificationOperationReturningResultDataRepositoryMethodModelBuilder<A extends Annotation, DMF extends SQLDataModelField, DMC extends SQLDataObjectModelClass<DMF>>
extends AbstractSQLOperationDataRepositoryMethodModelBuilder<A, DMF, DMC> {
    public final boolean isSupported(DataRepositoryMethodSignature dataRepositoryMethodSignature, DataGenerationContext<DMF, DMC> dataGenerationContext) {
        return super.isSupported(dataRepositoryMethodSignature, dataGenerationContext) && this.isEntityResultReturn(dataGenerationContext, dataRepositoryMethodSignature.getMethodResult());
    }

    @Override
    protected void validateMethod(ParsedSQL<A> parsedSQL, MethodResult methodResult, DataGenerationContext<DMF, DMC> dataGenerationContext, ExecutableElement method, DataMethodParams dataMethodParams) {
        List customSelectParams = dataMethodParams.getParamsOfGroup("CUSTOM_SELECT_GROUP");
        if (!customSelectParams.isEmpty()) {
            throw new InterruptProcessingException(((Variable)customSelectParams.get(0)).getElement(), "Parameter(s) annotated by '@?' annotation is(are) not supported for '?' operation. Remove this(these) parameter(s)!", new Object[]{CustomSelect.class, this.operationType().getSimpleName().toUpperCase(Locale.ENGLISH)});
        }
        Optional.ofNullable(method.getAnnotation(ExpectedUpdatedRowsCount.class)).ifPresent(expectedUpdatedRowsCount -> {
            int expectedValue = expectedUpdatedRowsCount.value();
            if (methodResult.isOneItem()) {
                if (expectedValue > 1) {
                    throw new InterruptProcessingException((Element)method, "Expected updated rows count value conflict with repository method result: expectedValue is ?, but the repository method returns the single result! Set valid expected rows count value or change the repository method result!", new Object[]{expectedValue});
                }
            } else {
                throw new InterruptProcessingException((Element)method, "'@?' annotation is not supported for repository methods that return not single result! Remove unsupported annotation!", new Object[0]);
            }
        });
    }

    @Override
    protected void customizeClassHeaderBuilder(ClassHeader.Builder classHeaderBuilder, MethodResult methodResult, DataGenerationContext<DMF, DMC> dataGenerationContext, ExecutableElement method, SQLStatement sqlStatement) {
        classHeaderBuilder.addImports(new Class[]{Mono.class, Flux.class, Flowable.class, ArrayList.class});
        sqlStatement.getBindParams().forEach(p -> classHeaderBuilder.addImports(new TypeMirror[]{p.getType()}));
    }

    @Override
    protected void addEntityConverter(MethodResult methodResult, SQLMethodDescriptor<DMF, DMC> sqlMethodDescriptor, DataGenerationContext<DMF, DMC> dataGenerationContext, List<Variable> params, SQLStatement sqlStatement, Map<String, Object> templateArguments) {
        boolean isEntityParam = this.isEntityParam(params, dataGenerationContext);
        boolean isEntityFieldMap = sqlMethodDescriptor.getResult().isResultType(EntityFieldMap.class);
        boolean isEntityFieldList = sqlMethodDescriptor.getResult().isResultType(EntityFieldList.class);
        templateArguments.put("RETURN_ENTITY_FIELD_MAP", isEntityFieldMap);
        templateArguments.put("RETURN_ENTITY_FIELD_LIST", isEntityFieldList);
        if (isEntityParam) {
            templateArguments.put("ENTITY", params.get(0).getGetter());
            templateArguments.put("ENTITY_TO_DB_CONVERTER", GeneratedClassNames.getModelTransformerInstanceName((TypeMirror)params.get(0).getType(), EntityToR2DBCSQLDBConverter.class));
        }
        if (!isEntityFieldList && !isEntityFieldMap) {
            SQLDataObjectModelClass modelClass = (SQLDataObjectModelClass)sqlMethodDescriptor.getEntityResult().orElseThrow(Errors.createInternalErrorSupplier((String)"Method return result not found for '?' operation", (Object[])new Object[]{this.operationType().getSimpleName().toUpperCase(Locale.ENGLISH)}));
            String entityClass = Names.getSimpleName((String)modelClass.getJavaFullClassName());
            templateArguments.put("ENTITY_CLASS", entityClass);
            templateArguments.put("ENTITY_FROM_DB_CONVERTER", GeneratedClassNames.getModelTransformerInstanceName((String)entityClass, EntityFromR2DBCSQLDBConverter.class));
            templateArguments.put("ENTITY_RESULT_DIFFERS_FROM_ENTITY_PARAM", !isEntityParam || !params.get(0).is(modelClass.getJavaFullClassName()));
            EntitySetFieldsConverterMethod converterMethod = new EntitySetFieldsConverterMethod(sqlStatement);
            modelClass.addEntitySetFieldsConverterMethod(converterMethod);
            templateArguments.put("ENTITY_CONVERTER_METHOD", converterMethod.getName());
        }
    }
}

