/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.r2dbc.component.impl;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodBody;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.data.component.DataMethodParamsResolver;
import io.rxmicro.annotation.processor.data.model.CommonDataGroupRules;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.model.DataMethodParams;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.annotation.processor.data.sql.component.SQLBuilder;
import io.rxmicro.annotation.processor.data.sql.component.impl.AbstractSQLDataRepositoryMethodModelBuilder;
import io.rxmicro.annotation.processor.data.sql.model.CommonSQLGroupRules;
import io.rxmicro.annotation.processor.data.sql.model.ParsedSQL;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataModelField;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataObjectModelClass;
import io.rxmicro.annotation.processor.data.sql.model.SQLMethodBody;
import io.rxmicro.annotation.processor.data.sql.model.SQLMethodDescriptor;
import io.rxmicro.annotation.processor.data.sql.model.SQLStatement;
import io.rxmicro.data.DataRepositoryGeneratorConfig;
import io.rxmicro.data.sql.ExpectedUpdatedRowsCount;
import io.rxmicro.data.sql.model.EntityFieldList;
import io.rxmicro.data.sql.model.EntityFieldMap;
import io.rxmicro.data.sql.model.reactor.Transaction;
import io.rxmicro.logger.RequestIdSupplier;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractSQLOperationDataRepositoryMethodModelBuilder<A extends Annotation, DMF extends SQLDataModelField, DMC extends SQLDataObjectModelClass<DMF>>
extends AbstractSQLDataRepositoryMethodModelBuilder<DMF, DMC> {
    private final Map<String, Predicate<VariableElement>> groupRules = Map.of("REQUEST_ID_SUPPLIER_GROUP", CommonDataGroupRules.REQUEST_ID_SUPPLIER_PREDICATE, "TRANSACTION_GROUP", CommonSQLGroupRules.TRANSACTION_PREDICATE, "CUSTOM_SELECT_GROUP", CommonSQLGroupRules.CUSTOM_SELECT_PREDICATE);
    @Inject
    private DataMethodParamsResolver dataMethodParamsResolver;
    @Inject
    private SQLBuilder<A, DMF, DMC> sqlBuilder;

    protected boolean isEntityResultReturn(DataGenerationContext<DMF, DMC> dataGenerationContext, MethodResult methodResult) {
        return dataGenerationContext.isEntityResultType(methodResult.getResultType()) || dataGenerationContext.isEntityParamType(methodResult.getResultType()) || methodResult.isResultType(EntityFieldList.class) || methodResult.isResultType(EntityFieldMap.class);
    }

    protected final MethodBody buildBody(ClassHeader.Builder classHeaderBuilder, ExecutableElement method, MethodResult methodResult, DataRepositoryGeneratorConfig dataRepositoryGeneratorConfig, DataGenerationContext<DMF, DMC> dataGenerationContext) {
        DataMethodParams dataMethodParams = this.dataMethodParamsResolver.resolve(method, this.groupRules);
        this.validateCommonDataMethodParams(dataMethodParams);
        List params = dataMethodParams.getOtherParams();
        SQLMethodDescriptor sqlMethodDescriptor = this.buildSQLMethodDescriptor(method, params, methodResult, dataGenerationContext);
        ParsedSQL<A> parsedSQL = this.parseSQL(method, dataMethodParams);
        this.validateMethod(parsedSQL, methodResult, dataGenerationContext, method, dataMethodParams);
        HashMap<String, Object> templateArguments = new HashMap<String, Object>();
        this.putCommonArguments(dataRepositoryGeneratorConfig, templateArguments);
        templateArguments.put("RETURN", methodResult);
        Optional.ofNullable(method.getAnnotation(ExpectedUpdatedRowsCount.class)).ifPresent(expectedUpdatedRowsCount -> {
            this.validateExpectedUpdatedRowsCount(method, expectedUpdatedRowsCount.value());
            templateArguments.put("EXPECTED_UPDATED_ROWS_COUNT", expectedUpdatedRowsCount.value());
        });
        templateArguments.put("RETURN_ENTITY_FIELD_MAP", methodResult.isResultType(EntityFieldMap.class));
        templateArguments.put("RETURN_ENTITY_FIELD_LIST", methodResult.isResultType(EntityFieldList.class));
        SQLStatement sqlStatement = this.sqlBuilder.build(classHeaderBuilder, parsedSQL, method, sqlMethodDescriptor);
        this.customizeClassHeaderBuilder(classHeaderBuilder, methodResult, dataGenerationContext, method, sqlStatement);
        templateArguments.put("SQL", sqlStatement);
        this.addEntityConverter(methodResult, sqlMethodDescriptor, dataGenerationContext, params, sqlStatement, templateArguments);
        dataMethodParams.getSingleParamOfGroup("TRANSACTION_GROUP").ifPresent(t -> templateArguments.put("TRANSACTION", t.getName()));
        templateArguments.put("CONNECTION_CREATE_PARAM", dataMethodParams.getSingleParamOfGroup("REQUEST_ID_SUPPLIER_GROUP").map(Variable::getName).orElse(""));
        return new SQLMethodBody(this.methodBodyGenerator.generate(this.getTemplateName(), templateArguments));
    }

    protected void validateCommonDataMethodParams(DataMethodParams dataMethodParams) {
        List requestIdSupplierParams = dataMethodParams.getParamsOfGroup("REQUEST_ID_SUPPLIER_GROUP");
        if (requestIdSupplierParams.size() > 1) {
            throw this.createNotUniqueParameterException(requestIdSupplierParams, 1, RequestIdSupplier.class);
        }
        List transactionParams = dataMethodParams.getParamsOfGroup("TRANSACTION_GROUP");
        if (transactionParams.size() > 1) {
            throw this.createNotUniqueParameterException(transactionParams, 1, Transaction.class);
        }
        if (!transactionParams.isEmpty() && !requestIdSupplierParams.isEmpty()) {
            throw new InterruptProcessingException(((Variable)requestIdSupplierParams.get(0)).getElement(), "'?' parameter is redundant. The request id supplier must be bind to the transaction object. For example: 'ReactiveType<Transaction> beginTransaction(RequestIdSupplier requestIdSupplier);' Remove this parameter!", new Object[]{((Variable)requestIdSupplierParams.get(0)).getName()});
        }
        this.validatePageableParameter(dataMethodParams);
    }

    protected final void validateExpectedUpdatedRowsCount(ExecutableElement method, int expectedValue) {
        if (expectedValue < 0) {
            throw new InterruptProcessingException((Element)method, "Invalid value for '@?' annotation: ?. Must be >= 0!", new Object[]{ExpectedUpdatedRowsCount.class.getSimpleName(), expectedValue});
        }
    }

    protected void customizeClassHeaderBuilder(ClassHeader.Builder classHeaderBuilder, MethodResult methodResult, DataGenerationContext<DMF, DMC> dataGenerationContext, ExecutableElement method, SQLStatement sqlStatement) {
        classHeaderBuilder.addImports(new Class[]{Mono.class, Flux.class});
    }

    protected abstract void validateMethod(ParsedSQL<A> var1, MethodResult var2, DataGenerationContext<DMF, DMC> var3, ExecutableElement var4, DataMethodParams var5);

    protected abstract ParsedSQL<A> parseSQL(ExecutableElement var1, DataMethodParams var2);

    protected abstract void addEntityConverter(MethodResult var1, SQLMethodDescriptor<DMF, DMC> var2, DataGenerationContext<DMF, DMC> var3, List<Variable> var4, SQLStatement var5, Map<String, Object> var6);

    protected abstract String getTemplateName();
}

