/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.r2dbc.component.impl.method;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodBody;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.model.DataRepositoryMethodSignature;
import io.rxmicro.annotation.processor.data.sql.component.impl.AbstractSQLDataRepositoryMethodModelBuilder;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataModelField;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataObjectModelClass;
import io.rxmicro.annotation.processor.data.sql.model.SQLMethodBody;
import io.rxmicro.data.DataRepositoryGeneratorConfig;
import io.rxmicro.data.sql.model.IsolationLevel;
import io.rxmicro.data.sql.model.TransactionType;
import io.rxmicro.data.sql.model.rxjava3.Transaction;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import reactor.core.publisher.Mono;

@Singleton
public class CreateTransactionSQLRepositoryMethodModelBuilder<DMF extends SQLDataModelField, DMC extends SQLDataObjectModelClass<DMF>>
extends AbstractSQLDataRepositoryMethodModelBuilder<DMF, DMC> {
    public boolean isSupported(DataRepositoryMethodSignature dataRepositoryMethodSignature, DataGenerationContext<DMF, DMC> dataGenerationContext) {
        return TransactionType.SUPPORTED_TRANSACTION_TYPES.stream().anyMatch(t -> dataRepositoryMethodSignature.getMethodResult().isResultType(t));
    }

    public Class<? extends Annotation> operationType() {
        return CreateTransaction.class;
    }

    protected MethodBody buildBody(ClassHeader.Builder classHeaderBuilder, ExecutableElement repositoryMethod, MethodResult methodResult, DataRepositoryGeneratorConfig dataRepositoryGeneratorConfig, DataGenerationContext<DMF, DMC> dataGenerationContext) {
        classHeaderBuilder.addImports(new Class[]{Mono.class});
        TransactionType transactionType = TransactionType.byClassName((String)methodResult.getResultType().toString());
        this.validateRequiredSingleReturnType(repositoryMethod, methodResult);
        this.validateTransactionType(repositoryMethod, methodResult, transactionType);
        HashMap<String, MethodResult> templateArguments = new HashMap<String, MethodResult>();
        templateArguments.put("RETURN", methodResult);
        this.getIsolationLevelParameter(repositoryMethod).ifPresent(v -> templateArguments.put("ISOLATION_LEVEL", (MethodResult)v.getSimpleName().toString()));
        return new SQLMethodBody(this.methodBodyGenerator.generate("data/sql/r2dbc/method/$$SQLRepositoryCreateTransactionMethodBodyTemplate.javaftl", templateArguments));
    }

    private void validateTransactionType(ExecutableElement repositoryMethod, MethodResult methodResult, TransactionType transactionType) {
        if (methodResult.isMono()) {
            if (transactionType != TransactionType.REACTOR) {
                throw new InterruptProcessingException((Element)repositoryMethod, "Invalid transaction type: '?'! Use '?' instead!", new Object[]{methodResult.getResultType(), io.rxmicro.data.sql.model.reactor.Transaction.class.getName()});
            }
        } else if (methodResult.isSingle()) {
            if (transactionType != TransactionType.RX_JAVA_3) {
                throw new InterruptProcessingException((Element)repositoryMethod, "Invalid transaction type: '?'! Use '?' instead!", new Object[]{methodResult.getResultType(), Transaction.class.getName()});
            }
        } else if (methodResult.isFuture()) {
            if (transactionType != TransactionType.COMPLETABLE_FUTURE) {
                throw new InterruptProcessingException((Element)repositoryMethod, "Invalid transaction type: '?'! Use '?' instead!", new Object[]{methodResult.getResultType(), io.rxmicro.data.sql.model.completablefuture.Transaction.class.getName()});
            }
        } else {
            throw new InterruptProcessingException((Element)repositoryMethod, "Unsupported method result: ?", new Object[]{methodResult});
        }
    }

    private Optional<VariableElement> getIsolationLevelParameter(ExecutableElement repositoryMethod) {
        VariableElement param;
        List<? extends VariableElement> parameters = repositoryMethod.getParameters();
        if (parameters.isEmpty()) {
            return Optional.empty();
        }
        if (parameters.size() == 1 && (param = parameters.get(0)).asType().toString().equals(IsolationLevel.class.getName())) {
            return Optional.of(param);
        }
        throw new InterruptProcessingException((Element)repositoryMethod, "Method can contains no parameters or one parameter of '?' type only", new Object[]{IsolationLevel.class.getName()});
    }

    private static @interface CreateTransaction {
    }
}

