/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.r2dbc.component.impl;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.method.MethodBody;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.annotation.processor.data.sql.component.SQLBuilder;
import io.rxmicro.annotation.processor.data.sql.component.impl.AbstractSQLDataRepositoryMethodModelBuilder;
import io.rxmicro.annotation.processor.data.sql.component.impl.MethodParamResolver;
import io.rxmicro.annotation.processor.data.sql.model.ParsedSQL;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataModelField;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataObjectModelClass;
import io.rxmicro.annotation.processor.data.sql.model.SQLMethodBody;
import io.rxmicro.annotation.processor.data.sql.model.SQLMethodDescriptor;
import io.rxmicro.annotation.processor.data.sql.model.SQLStatement;
import io.rxmicro.data.DataRepositoryGeneratorConfig;
import io.rxmicro.data.sql.model.EntityFieldList;
import io.rxmicro.data.sql.model.EntityFieldMap;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractSQLOperationDataRepositoryMethodModelBuilder<A extends Annotation, DMF extends SQLDataModelField, DMC extends SQLDataObjectModelClass<DMF>>
extends AbstractSQLDataRepositoryMethodModelBuilder<DMF, DMC> {
    @Inject
    private MethodParamResolver methodParamResolver;
    @Inject
    private SQLBuilder<A, DMF, DMC> sqlBuilder;

    protected boolean isEntityResultReturn(DataGenerationContext<DMF, DMC> dataGenerationContext, MethodResult methodResult) {
        return dataGenerationContext.isEntityResultType(methodResult.getResultType()) || dataGenerationContext.isEntityParamType(methodResult.getResultType()) || methodResult.isResultType(EntityFieldList.class) || methodResult.isResultType(EntityFieldMap.class);
    }

    protected MethodBody buildBody(ClassHeader.Builder classHeaderBuilder, ExecutableElement method, MethodResult methodResult, DataRepositoryGeneratorConfig dataRepositoryGeneratorConfig, DataGenerationContext<DMF, DMC> dataGenerationContext) {
        this.customizeClassHeaderBuilder(classHeaderBuilder, methodResult, dataGenerationContext, method);
        List params = this.methodParamResolver.getMethodParams(method.getParameters());
        SQLMethodDescriptor sqlMethodDescriptor = this.buildSQLMethodDescriptor(method, params, methodResult, dataGenerationContext);
        ParsedSQL<A> parsedSQL = this.parseSQL(method);
        this.validateMethod(parsedSQL, methodResult, dataGenerationContext, method, params);
        HashMap<String, Object> templateArguments = new HashMap<String, Object>();
        this.putCommonArguments(dataRepositoryGeneratorConfig, templateArguments);
        templateArguments.put("RETURN", methodResult);
        templateArguments.put("RETURN_ENTITY_FIELD_MAP", methodResult.isResultType(EntityFieldMap.class));
        templateArguments.put("RETURN_ENTITY_FIELD_LIST", methodResult.isResultType(EntityFieldList.class));
        SQLStatement sqlStatement = this.sqlBuilder.build(classHeaderBuilder, parsedSQL, method, sqlMethodDescriptor);
        templateArguments.put("SQL", sqlStatement);
        this.addEntityConverter(methodResult, sqlMethodDescriptor, dataGenerationContext, params, sqlStatement, templateArguments);
        this.getTransactionMethodParameter(method).ifPresent(t -> templateArguments.put("TRANSACTION", t));
        return new SQLMethodBody(this.methodBodyGenerator.generate(this.getTemplateName(), templateArguments));
    }

    protected void customizeClassHeaderBuilder(ClassHeader.Builder classHeaderBuilder, MethodResult methodResult, DataGenerationContext<DMF, DMC> dataGenerationContext, ExecutableElement method) {
        classHeaderBuilder.addImports(new Class[]{Mono.class, Flux.class});
    }

    protected abstract void validateMethod(ParsedSQL<A> var1, MethodResult var2, DataGenerationContext<DMF, DMC> var3, ExecutableElement var4, List<Variable> var5);

    protected abstract ParsedSQL<A> parseSQL(ExecutableElement var1);

    protected abstract void addEntityConverter(MethodResult var1, SQLMethodDescriptor<DMF, DMC> var2, DataGenerationContext<DMF, DMC> var3, List<Variable> var4, SQLStatement var5, Map<String, Object> var6);

    protected abstract String getTemplateName();
}

