/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.r2dbc.component.impl;

import io.reactivex.rxjava3.core.Flowable;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.common.util.Errors;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.model.DataRepositoryMethodSignature;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.annotation.processor.data.sql.model.EntitySetFieldsConverterMethod;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataModelField;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataObjectModelClass;
import io.rxmicro.annotation.processor.data.sql.model.SQLMethodDescriptor;
import io.rxmicro.annotation.processor.data.sql.model.SQLStatement;
import io.rxmicro.annotation.processor.data.sql.r2dbc.component.impl.AbstractSQLOperationDataRepositoryMethodModelBuilder;
import io.rxmicro.data.sql.model.EntityFieldList;
import io.rxmicro.data.sql.model.EntityFieldMap;
import io.rxmicro.data.sql.r2dbc.detail.EntityFromR2DBCSQLDBConverter;
import io.rxmicro.data.sql.r2dbc.detail.EntityToR2DBCSQLDBConverter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractSQLModificationOperationReturningResultDataRepositoryMethodModelBuilder<A extends Annotation, DMF extends SQLDataModelField, DMC extends SQLDataObjectModelClass<DMF>>
extends AbstractSQLOperationDataRepositoryMethodModelBuilder<A, DMF, DMC> {
    public final boolean isSupported(DataRepositoryMethodSignature dataRepositoryMethodSignature, DataGenerationContext<DMF, DMC> dataGenerationContext) {
        return super.isSupported(dataRepositoryMethodSignature, dataGenerationContext) && this.isEntityResultReturn(dataGenerationContext, dataRepositoryMethodSignature.getMethodResult());
    }

    @Override
    protected void customizeClassHeaderBuilder(ClassHeader.Builder classHeaderBuilder, MethodResult methodResult, DataGenerationContext<DMF, DMC> dataGenerationContext, ExecutableElement method) {
        classHeaderBuilder.addImports(new Class[]{Mono.class, Flux.class, Flowable.class, ArrayList.class});
    }

    @Override
    protected void addEntityConverter(MethodResult methodResult, SQLMethodDescriptor<DMF, DMC> sqlMethodDescriptor, DataGenerationContext<DMF, DMC> dataGenerationContext, List<Variable> params, SQLStatement sqlStatement, Map<String, Object> templateArguments) {
        boolean isEntityParam = this.isEntityParam(params, dataGenerationContext);
        boolean isEntityFieldMap = sqlMethodDescriptor.getResult().isResultType(EntityFieldMap.class);
        boolean isEntityFieldList = sqlMethodDescriptor.getResult().isResultType(EntityFieldList.class);
        templateArguments.put("IS_ENTITY_PARAM", isEntityParam);
        templateArguments.put("RETURN_ENTITY_FIELD_MAP", isEntityFieldMap);
        templateArguments.put("RETURN_ENTITY_FIELD_LIST", isEntityFieldList);
        DMC modelClass = this.getResultModelClassOrNull(sqlMethodDescriptor, isEntityParam, isEntityFieldMap, isEntityFieldList);
        if (isEntityParam) {
            templateArguments.put("ENTITY", params.get(0).getGetter());
            templateArguments.put("ENTITY_CONVERTER", GeneratedClassNames.getModelTransformerInstanceName((TypeMirror)params.get(0).getType(), EntityToR2DBCSQLDBConverter.class));
        } else if (modelClass != null) {
            String entityClass = Names.getSimpleName((String)modelClass.getJavaFullClassName());
            templateArguments.put("ENTITY_CLASS", entityClass);
            templateArguments.put("ENTITY_CONVERTER", GeneratedClassNames.getModelTransformerInstanceName((String)entityClass, EntityFromR2DBCSQLDBConverter.class));
        }
        if (modelClass != null) {
            EntitySetFieldsConverterMethod converterMethod = new EntitySetFieldsConverterMethod(sqlStatement);
            modelClass.addEntitySetFieldsConverterMethod(converterMethod);
            templateArguments.put("ENTITY_CONVERTER_METHOD", converterMethod.getName());
        }
    }

    private DMC getResultModelClassOrNull(SQLMethodDescriptor<DMF, DMC> sqlMethodDescriptor, boolean isEntityParam, boolean isEntityFieldMap, boolean isEntityFieldList) {
        if (!isEntityFieldList && !isEntityFieldMap) {
            String errorMessageTemplate;
            Optional modelClassOptional;
            if (isEntityParam) {
                modelClassOptional = sqlMethodDescriptor.getEntityParam().or(() -> sqlMethodDescriptor.getEntityResult());
                errorMessageTemplate = "Method entity param or return result not found for '?' operation";
            } else {
                modelClassOptional = sqlMethodDescriptor.getEntityResult();
                errorMessageTemplate = "Method return result not found for '?' operation";
            }
            return (DMC)((SQLDataObjectModelClass)modelClassOptional.orElseThrow(Errors.createInternalErrorSupplier((String)errorMessageTemplate, (Object[])new Object[]{this.operationType().getSimpleName().toUpperCase(Locale.ENGLISH)})));
        }
        return null;
    }
}

