/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.mongo.component.impl.method;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.common.util.Errors;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.model.DataRepositoryMethodSignature;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.annotation.processor.data.mongo.component.BsonExpressionBuilder;
import io.rxmicro.annotation.processor.data.mongo.component.impl.MethodParameterReader;
import io.rxmicro.annotation.processor.data.mongo.component.impl.method.AbstractUpdateOperationMongoRepositoryMethodModelBuilder;
import io.rxmicro.annotation.processor.data.mongo.model.MongoDataModelField;
import io.rxmicro.annotation.processor.data.mongo.model.MongoDataObjectModelClass;
import io.rxmicro.data.DataRepositoryGeneratorConfig;
import io.rxmicro.data.mongo.DocumentId;
import io.rxmicro.data.mongo.detail.EntityToMongoDBConverter;
import io.rxmicro.data.mongo.operation.Update;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class UpdateDocumentOperationMongoRepositoryMethodModelBuilder
extends AbstractUpdateOperationMongoRepositoryMethodModelBuilder {
    @Inject
    private BsonExpressionBuilder bsonExpressionBuilder;

    public boolean isSupported(DataRepositoryMethodSignature dataRepositoryMethodSignature, DataGenerationContext<MongoDataModelField, MongoDataObjectModelClass> dataGenerationContext) {
        return super.isSupported(dataRepositoryMethodSignature, dataGenerationContext) && dataRepositoryMethodSignature.getMethod().getAnnotation(Update.class).update().isBlank() && !dataRepositoryMethodSignature.getMethod().getAnnotation(Update.class).filter().isBlank();
    }

    @Override
    List<String> buildUpdateBody(ClassHeader.Builder classHeaderBuilder, ExecutableElement method, MethodResult methodResult, MethodParameterReader methodParameterReader, DataRepositoryGeneratorConfig dataRepositoryGeneratorConfig, DataGenerationContext<MongoDataModelField, MongoDataObjectModelClass> dataGenerationContext) {
        Variable document = this.getDocument(method, methodParameterReader, dataGenerationContext);
        HashMap<String, Object> templateArguments = new HashMap<String, Object>();
        this.putCommonArguments(dataRepositoryGeneratorConfig, templateArguments);
        templateArguments.put("RETURN", methodResult);
        Update annotation = method.getAnnotation(Update.class);
        templateArguments.put("FILTER", this.bsonExpressionBuilder.build(method, classHeaderBuilder, annotation.filter(), methodParameterReader));
        templateArguments.put("UPSERT", annotation.upsert());
        templateArguments.put("DOCUMENT", document.getName());
        templateArguments.put("DOCUMENT_CONVERTER", GeneratedClassNames.getModelTransformerInstanceName((String)Names.getSimpleName((TypeMirror)document.getType()), EntityToMongoDBConverter.class));
        return this.methodBodyGenerator.generate("data/mongo/method/$$MongoRepositoryUpdateDocumentMethodBodyTemplate.javaftl", templateArguments);
    }

    private Variable getDocument(ExecutableElement method, MethodParameterReader methodParameterReader, DataGenerationContext<MongoDataModelField, MongoDataObjectModelClass> dataGenerationContext) {
        Variable mongoVar = methodParameterReader.nextVar().orElseThrow(() -> {
            throw new InterruptProcessingException((Element)method, "The first method parameter must be a document!", new Object[0]);
        });
        if (!dataGenerationContext.isEntityParamType(mongoVar.getType())) {
            throw new InterruptProcessingException((Element)method, "The first method parameter must be a document!", new Object[0]);
        }
        MongoDataObjectModelClass modelClass = (MongoDataObjectModelClass)((Object)dataGenerationContext.getEntityParamModel(mongoVar.getType()).orElseThrow(Errors.createInternalErrorSupplier((String)"MongoDataObjectModelClass not found by by: ?", (Object[])new Object[]{mongoVar.getType()})));
        if (modelClass.getParamEntries().stream().anyMatch(e -> ((MongoDataModelField)((Object)((Object)e.getKey()))).getAnnotation(DocumentId.class) != null)) {
            throw new InterruptProcessingException((Element)method, "Can't update document of '?' type, because detected a field annotated by @? annotation. Remove document id field from the document class or remove filter annotation option!", new Object[]{mongoVar.getType().toString(), DocumentId.class.getName()});
        }
        return mongoVar;
    }
}

