/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.mongo.component.impl.method;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mongodb.client.model.CountOptions;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.mongo.component.BsonExpressionBuilder;
import io.rxmicro.annotation.processor.data.mongo.component.impl.AbstractMongoRepositoryMethodModelBuilder;
import io.rxmicro.annotation.processor.data.mongo.component.impl.MethodParameterReader;
import io.rxmicro.annotation.processor.data.mongo.model.MongoDataModelField;
import io.rxmicro.annotation.processor.data.mongo.model.MongoDataObjectModelClass;
import io.rxmicro.data.DataRepositoryGeneratorConfig;
import io.rxmicro.data.mongo.detail.MongoQueries;
import io.rxmicro.data.mongo.operation.CountDocuments;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.bson.Document;
import org.reactivestreams.Publisher;

@Singleton
public final class CountDocumentsOperationMongoRepositoryMethodModelBuilder
extends AbstractMongoRepositoryMethodModelBuilder {
    @Inject
    private BsonExpressionBuilder bsonExpressionBuilder;

    public Class<? extends Annotation> operationType() {
        return CountDocuments.class;
    }

    @Override
    protected List<String> buildBody(ClassHeader.Builder classHeaderBuilder, ExecutableElement method, MethodResult methodResult, MethodParameterReader methodParameterReader, DataRepositoryGeneratorConfig dataRepositoryGeneratorConfig, DataGenerationContext<MongoDataModelField, MongoDataObjectModelClass> dataGenerationContext) {
        String hint;
        classHeaderBuilder.addImports(new Class[]{Publisher.class, Document.class, CountOptions.class, MongoQueries.class});
        this.validateRequiredSingleReturnType(method, methodResult);
        this.validateReturnType(method, methodResult.getResultType(), new Class[]{Long.class});
        HashMap<String, Object> templateArguments = new HashMap<String, Object>();
        this.putCommonArguments(dataRepositoryGeneratorConfig, templateArguments);
        templateArguments.put("RETURN", methodResult);
        CountDocuments annotation = method.getAnnotation(CountDocuments.class);
        String query = annotation.query();
        if (!query.isBlank()) {
            templateArguments.put("QUERY", this.bsonExpressionBuilder.build(method, classHeaderBuilder, query, methodParameterReader));
        }
        if (!(hint = annotation.hint()).isBlank()) {
            templateArguments.put("HINT", this.bsonExpressionBuilder.build(method, classHeaderBuilder, hint, methodParameterReader));
        }
        Class annotationType = annotation.annotationType();
        int limit = annotation.limit();
        int skip = annotation.skip();
        this.setPageable(method, methodParameterReader, templateArguments, annotationType, limit, skip);
        return this.methodBodyGenerator.generate("data/mongo/method/$$MongoRepositoryCountDocumentsMethodBodyTemplate.javaftl", templateArguments);
    }
}

