/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.mongo.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.impl.BaseProcessorComponent;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.data.component.EntityConverterBuilder;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.model.DataModelField;
import io.rxmicro.annotation.processor.data.mongo.model.EntityFromDBConverterClassStructure;
import io.rxmicro.annotation.processor.data.mongo.model.EntityToDBConverterClassStructure;
import io.rxmicro.annotation.processor.data.mongo.model.MongoDataModelField;
import io.rxmicro.annotation.processor.data.mongo.model.MongoDataObjectModelClass;
import io.rxmicro.data.mongo.DocumentId;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Singleton
public final class MongoDocumentEntityConverterBuilder
extends BaseProcessorComponent
implements EntityConverterBuilder<MongoDataModelField, MongoDataObjectModelClass> {
    @Inject
    private SupportedTypesProvider supportedTypesProvider;

    public Set<? extends ClassStructure> build(DataGenerationContext<MongoDataModelField, MongoDataObjectModelClass> dataGenerationContext) {
        HashSet result = new HashSet();
        dataGenerationContext.getEntityParamMap().values().stream().flatMap(m -> Stream.concat(Stream.of(m), m.getAllChildrenObjectModelClasses().stream())).map(m -> (MongoDataObjectModelClass)m.asObject(MongoDataObjectModelClass.class)).collect(Collectors.toSet()).forEach(m -> result.add(this.createEntityToDBConverterClassStructure((MongoDataObjectModelClass)((Object)m))));
        dataGenerationContext.getEntityReturnMap().values().stream().flatMap(m -> Stream.concat(Stream.of(m), m.getAllChildrenObjectModelClasses().stream())).map(m -> (MongoDataObjectModelClass)m.asObject(MongoDataObjectModelClass.class)).collect(Collectors.toSet()).forEach(m -> result.add(new EntityFromDBConverterClassStructure((MongoDataObjectModelClass)((Object)m))));
        return result;
    }

    private EntityToDBConverterClassStructure createEntityToDBConverterClassStructure(MongoDataObjectModelClass modelClass) {
        return this.getIdField(modelClass).map(id -> {
            this.validateIdFieldType((DataModelField)id.getKey());
            return new EntityToDBConverterClassStructure((Map.Entry<MongoDataModelField, ModelClass>)id, modelClass);
        }).orElse(new EntityToDBConverterClassStructure(modelClass));
    }

    private void validateIdFieldType(DataModelField id) {
        if (!this.supportedTypesProvider.isModelPrimitive(id.getFieldClass())) {
            throw new InterruptProcessingException(id.getFieldElement(), "Document id must be a primitive type", new Object[0]);
        }
    }

    private Optional<Map.Entry<MongoDataModelField, ModelClass>> getIdField(MongoDataObjectModelClass modelClass) {
        List ids = modelClass.getParamEntries().stream().filter(e -> ((MongoDataModelField)((Object)((Object)e.getKey()))).getAnnotation(DocumentId.class) != null).collect(Collectors.toList());
        if (ids.size() > 1) {
            throw new InterruptProcessingException(((MongoDataModelField)((Object)((Map.Entry)ids.get(ids.size() - 1)).getKey())).getFieldElement(), "Expected one field annotated by '?' per document", new Object[]{DocumentId.class.getName()});
        }
        return ids.isEmpty() ? Optional.empty() : Optional.of((Map.Entry)ids.get(0));
    }
}

