/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.mongo.component.impl;

import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.data.model.DataMethodParams;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.data.Pageable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public final class MethodParameterReader {
    private final ListIterator<Variable> iterator;

    public MethodParameterReader(DataMethodParams dataMethodParams) {
        this.iterator = new ArrayList(dataMethodParams.getOtherParams()).listIterator();
    }

    public Optional<Variable> nextVar() {
        return this.iterator.hasNext() ? Optional.of(this.iterator.next()) : Optional.empty();
    }

    public Optional<Variable> nextIfLimit() {
        return this.nextIf(Variable::isLimit);
    }

    public Optional<Variable> nextIfSkip() {
        return this.nextIf(Variable::isSkip);
    }

    private Optional<Variable> nextIf(Predicate<Variable> predicate) {
        if (this.iterator.hasNext()) {
            Variable var = this.iterator.next();
            if (predicate.test(var)) {
                return Optional.of(var);
            }
            this.iterator.previous();
        }
        return Optional.empty();
    }

    public List<Variable> getVars(ExecutableElement repositoryMethod, int count) {
        if (count == 0) {
            return List.of();
        }
        try {
            return IntStream.range(0, count).mapToObj(value -> this.iterator.next()).collect(Collectors.toList());
        }
        catch (NoSuchElementException ignore) {
            throw new InterruptProcessingException((Element)repositoryMethod, "Missing method parameter for parameter placeholder!", new Object[0]);
        }
    }

    public List<Variable> getUnusedVars() {
        ArrayList<Variable> res = new ArrayList<Variable>();
        while (this.iterator.hasNext()) {
            Variable mongoVar = this.iterator.next();
            if (mongoVar.is(Pageable.class)) {
                if (!mongoVar.isLimit()) continue;
                res.add(mongoVar);
                continue;
            }
            res.add(mongoVar);
        }
        return res;
    }
}

