/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.mongo.component.impl;

import com.google.inject.Inject;
import com.mongodb.BasicDBObject;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodBody;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.data.component.DataMethodParamsResolver;
import io.rxmicro.annotation.processor.data.component.impl.AbstractDataRepositoryMethodModelBuilder;
import io.rxmicro.annotation.processor.data.model.CommonDataGroupRules;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.model.DataMethodParams;
import io.rxmicro.annotation.processor.data.model.DataRepositoryMethodSignature;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.annotation.processor.data.mongo.component.MongoRepositoryMethodModelBuilder;
import io.rxmicro.annotation.processor.data.mongo.component.impl.MethodParameterReader;
import io.rxmicro.annotation.processor.data.mongo.model.MongoDataModelField;
import io.rxmicro.annotation.processor.data.mongo.model.MongoDataObjectModelClass;
import io.rxmicro.annotation.processor.data.mongo.model.MongoMethodBody;
import io.rxmicro.annotation.processor.data.mongo.model.MongoRepositoryMethod;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Strings;
import io.rxmicro.data.DataRepositoryGeneratorConfig;
import io.rxmicro.data.detail.adapter.PublisherToFluxFutureAdapter;
import io.rxmicro.data.detail.adapter.PublisherToOptionalMonoFutureAdapter;
import io.rxmicro.data.detail.adapter.PublisherToRequiredMonoFutureAdapter;
import io.rxmicro.data.mongo.MongoRepository;
import io.rxmicro.data.mongo.operation.Delete;
import io.rxmicro.data.mongo.operation.Insert;
import io.rxmicro.data.mongo.operation.Update;
import io.rxmicro.logger.RequestIdSupplier;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.bson.conversions.Bson;

public abstract class AbstractMongoRepositoryMethodModelBuilder
extends AbstractDataRepositoryMethodModelBuilder<MongoDataModelField, MongoRepositoryMethod, MongoDataObjectModelClass>
implements MongoRepositoryMethodModelBuilder {
    private static final Map<Class<? extends Annotation>, String> MONGO_DB_NOT_STD_OPERATION_NAMES = Map.of(Insert.class, "insertOne", Update.class, "updateMany", Delete.class, "deleteMany");
    private final Map<String, Predicate<VariableElement>> groupRules = Map.of("REQUEST_ID_SUPPLIER_GROUP", CommonDataGroupRules.REQUEST_ID_SUPPLIER_PREDICATE);
    @Inject
    private DataMethodParamsResolver dataMethodParamsResolver;

    protected final MongoRepositoryMethod build(DataRepositoryMethodSignature dataRepositoryMethodSignature, MethodBody body) {
        String collection = dataRepositoryMethodSignature.getDataRepositoryInterfaceSignature().getRepositoryInterface().getAnnotation(MongoRepository.class).collection();
        String operation = Optional.ofNullable(MONGO_DB_NOT_STD_OPERATION_NAMES.get(this.operationType())).orElseGet(() -> Strings.unCapitalize((String)this.operationType().getSimpleName()));
        return new MongoRepositoryMethod(Formats.format((String)"db.?.?()", (Object[])new Object[]{collection, operation}), dataRepositoryMethodSignature, body);
    }

    protected final void addCommonImports(ClassHeader.Builder classHeaderBuilder, MethodResult methodResult) {
        classHeaderBuilder.addImports(new Class[]{Bson.class, BasicDBObject.class});
        if (methodResult.isFuture()) {
            if (methodResult.isOneItem()) {
                if (methodResult.isOptional()) {
                    classHeaderBuilder.addImports(new Class[]{PublisherToOptionalMonoFutureAdapter.class});
                } else {
                    classHeaderBuilder.addImports(new Class[]{PublisherToRequiredMonoFutureAdapter.class});
                }
            } else {
                classHeaderBuilder.addImports(new Class[]{PublisherToFluxFutureAdapter.class, Collectors.class});
            }
        }
    }

    protected final MethodBody buildBody(ClassHeader.Builder classHeaderBuilder, ExecutableElement method, MethodResult methodResult, DataRepositoryGeneratorConfig dataRepositoryGeneratorConfig, DataGenerationContext<MongoDataModelField, MongoDataObjectModelClass> generationContext) {
        DataMethodParams dataMethodParams = this.dataMethodParamsResolver.resolve(method, this.groupRules);
        this.validateCommonDataMethodParams(dataMethodParams);
        MethodParameterReader methodParameterReader = new MethodParameterReader(dataMethodParams);
        List<String> content = this.buildBody(classHeaderBuilder, method, methodResult, methodParameterReader, dataRepositoryGeneratorConfig, generationContext);
        this.validateUnusedMethodParameters(method, methodParameterReader);
        return new MongoMethodBody(content);
    }

    protected abstract List<String> buildBody(ClassHeader.Builder var1, ExecutableElement var2, MethodResult var3, MethodParameterReader var4, DataRepositoryGeneratorConfig var5, DataGenerationContext<MongoDataModelField, MongoDataObjectModelClass> var6);

    protected void validateCommonDataMethodParams(DataMethodParams dataMethodParams) {
        List requestIdSupplierParams = dataMethodParams.getParamsOfGroup("REQUEST_ID_SUPPLIER_GROUP");
        if (!requestIdSupplierParams.isEmpty()) {
            Variable variable = (Variable)requestIdSupplierParams.get(0);
            throw new InterruptProcessingException(variable.getElement(), "Unfortunately, the RxMicro framework does not support the '?' parameter for Mongo data repositories yet! Remove unsupported parameter!", new Object[]{RequestIdSupplier.class.getName()});
        }
        this.validatePageableParameter(dataMethodParams);
    }

    private void validateUnusedMethodParameters(ExecutableElement repositoryMethod, MethodParameterReader methodParameterReader) {
        List<Variable> unusedParameters = methodParameterReader.getUnusedVars();
        if (!unusedParameters.isEmpty()) {
            throw new InterruptProcessingException((Element)repositoryMethod, "The following parameter(s) unused: [?]. Remove it or add missing placeholder(s)!", new Object[]{unusedParameters.stream().map(Variable::toString).collect(Collectors.joining(", "))});
        }
    }

    protected final void setPageable(ExecutableElement repositoryMethod, MethodParameterReader methodParameterReader, Map<String, Object> templateArguments, Class<? extends Annotation> annotationClass, int limit, int skip) {
        if (limit > -1) {
            templateArguments.put("LIMIT", limit);
        }
        if (skip > -1) {
            templateArguments.put("SKIP", skip);
        }
        Optional<Variable> limitVar = methodParameterReader.nextIfLimit();
        Optional<Variable> skipVar = methodParameterReader.nextIfSkip();
        if (limitVar.isEmpty()) {
            limitVar = methodParameterReader.nextIfLimit();
        }
        limitVar.ifPresent(var -> {
            templateArguments.put("LIMIT", var.getGetter());
            if (limit > -1) {
                this.warn(repositoryMethod, "Method parameter '?' overrides annotation parameter: '?.limit()'", new Object[]{var.getName(), annotationClass.getName()});
            }
        });
        skipVar.ifPresent(var -> {
            templateArguments.put("SKIP", var.getGetter());
            if (skip > -1) {
                this.warn(repositoryMethod, "Method parameter '?' overrides annotation parameter: '?.skip()'", new Object[]{var.getName(), annotationClass.getName()});
            }
        });
    }
}

