/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.mongo.model;

import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.data.Pageable;
import java.util.Objects;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;

public class MongoVariable
extends Variable {
    private final boolean limit;
    private final boolean skip;

    public MongoVariable(VariableElement element, String name) {
        super(element, name);
        if (Pageable.class.getName().equals(element.asType().toString())) {
            this.limit = name.contains("getLimit");
            this.skip = name.contains("getSkip");
        } else {
            this.limit = Pageable.LIMIT_NAMES.contains(element.getSimpleName().toString()) && element.asType().getKind() == TypeKind.INT;
            this.skip = Pageable.OFFSET_NAMES.contains(element.getSimpleName().toString()) && element.asType().getKind() == TypeKind.INT;
        }
    }

    public boolean isLimit() {
        return this.limit;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.limit, this.skip);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        MongoVariable mongoVar = (MongoVariable)((Object)other);
        return this.limit == mongoVar.limit && this.skip == mongoVar.skip;
    }
}

