/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.mongo.component.impl.method;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mongodb.reactivestreams.client.FindPublisher;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.mongo.component.BsonExpressionBuilder;
import io.rxmicro.annotation.processor.data.mongo.component.impl.AbstractMongoRepositoryMethodModelBuilder;
import io.rxmicro.annotation.processor.data.mongo.component.impl.MethodParameterReader;
import io.rxmicro.annotation.processor.data.mongo.model.MongoDataModelField;
import io.rxmicro.annotation.processor.data.mongo.model.MongoDataObjectModelClass;
import io.rxmicro.data.DataRepositoryGeneratorConfig;
import io.rxmicro.data.mongo.detail.EntityFromMongoDBConverter;
import io.rxmicro.data.mongo.operation.Find;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.bson.Document;
import reactor.core.publisher.Flux;

@Singleton
public final class FindOperationMongoRepositoryMethodModelBuilder
extends AbstractMongoRepositoryMethodModelBuilder {
    @Inject
    private BsonExpressionBuilder bsonExpressionBuilder;

    public Class<? extends Annotation> operationType() {
        return Find.class;
    }

    @Override
    protected List<String> buildBody(ClassHeader.Builder classHeaderBuilder, ExecutableElement method, MethodResult methodResult, MethodParameterReader methodParameterReader, DataRepositoryGeneratorConfig dataRepositoryGeneratorConfig, DataGenerationContext<MongoDataModelField, MongoDataObjectModelClass> dataGenerationContext) {
        String sort;
        String hint;
        String projection;
        this.addImports(classHeaderBuilder);
        this.validateReactiveTypeWithExcluded(method, methodResult, new Class[]{Completable.class});
        this.validateReturnType(method, methodResult.getResultType(), dataGenerationContext.getEntityResultTypes());
        HashMap<String, Object> templateArguments = new HashMap<String, Object>();
        this.putCommonArguments(dataRepositoryGeneratorConfig, templateArguments);
        templateArguments.put("RETURN", methodResult);
        templateArguments.put("ENTITY_CONVERTER", GeneratedClassNames.getModelTransformerInstanceName((TypeMirror)methodResult.getResultType(), EntityFromMongoDBConverter.class));
        Find annotation = method.getAnnotation(Find.class);
        String query = annotation.query();
        if (!query.isEmpty()) {
            templateArguments.put("QUERY", this.bsonExpressionBuilder.build(method, classHeaderBuilder, query, methodParameterReader));
        }
        if (!(projection = annotation.projection()).isEmpty()) {
            templateArguments.put("PROJECTION", this.bsonExpressionBuilder.build(method, classHeaderBuilder, projection, methodParameterReader));
        }
        if (!(hint = annotation.hint()).isEmpty()) {
            templateArguments.put("HINT", this.bsonExpressionBuilder.build(method, classHeaderBuilder, hint, methodParameterReader));
        }
        if (!(sort = annotation.sort()).isEmpty()) {
            templateArguments.put("SORT", this.bsonExpressionBuilder.build(method, classHeaderBuilder, sort, methodParameterReader));
        }
        Class annotationType = annotation.annotationType();
        int limit = annotation.limit();
        int skip = annotation.skip();
        this.setPageable(method, methodParameterReader, templateArguments, annotationType, limit, skip);
        return this.methodBodyGenerator.generate("data/mongo/method/$$MongoRepositoryFindMethodBodyTemplate.javaftl", templateArguments);
    }

    private void addImports(ClassHeader.Builder classHeaderBuilder) {
        classHeaderBuilder.addImports(new Class[]{Document.class, FindPublisher.class, Flux.class, Flowable.class, ArrayList.class});
    }
}

