/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.mongo.component.impl;

import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.annotation.processor.data.mongo.model.MongoVariable;
import io.rxmicro.common.util.Formats;
import io.rxmicro.data.Pageable;
import io.rxmicro.data.RepeatParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public final class MethodParameterReader {
    private final ListIterator<MongoVariable> iterator;

    public MethodParameterReader(List<? extends VariableElement> parameters, SupportedTypesProvider supportedTypesProvider) {
        ArrayList<MongoVariable> vars = new ArrayList<MongoVariable>(parameters.size());
        VariableElement page = null;
        for (VariableElement variableElement : parameters) {
            String value = variableElement.getSimpleName().toString();
            if (!supportedTypesProvider.getStandardMethodParameters().contains(variableElement.asType())) {
                MongoVariable var = new MongoVariable(variableElement, value);
                int repeatCount = Optional.ofNullable(variableElement.getAnnotation(RepeatParameter.class)).map(RepeatParameter::value).orElse(1);
                for (int i = 0; i < repeatCount; ++i) {
                    vars.add(var);
                }
                continue;
            }
            if (!Pageable.class.getName().equals(variableElement.asType().toString())) continue;
            if (page != null) {
                throw new InterruptProcessingException((Element)variableElement, "Only one '?' parameter allowed per method!", new Object[]{Pageable.class.getName()});
            }
            page = variableElement;
            vars.add(new MongoVariable(variableElement, Formats.format((String)"?.getLimit()", (Object[])new Object[]{value})));
            vars.add(new MongoVariable(variableElement, Formats.format((String)"?.getSkip()", (Object[])new Object[]{value})));
        }
        this.iterator = vars.listIterator();
    }

    public Optional<MongoVariable> nextVar() {
        return this.iterator.hasNext() ? Optional.of(this.iterator.next()) : Optional.empty();
    }

    public Optional<MongoVariable> nextIfLimit() {
        return this.nextIf(MongoVariable::isLimit);
    }

    public Optional<MongoVariable> nextIfSkip() {
        return this.nextIf(MongoVariable::isSkip);
    }

    private Optional<MongoVariable> nextIf(Predicate<MongoVariable> predicate) {
        if (this.iterator.hasNext()) {
            MongoVariable mongoVar = this.iterator.next();
            if (predicate.test(mongoVar)) {
                return Optional.of(mongoVar);
            }
            this.iterator.previous();
        }
        return Optional.empty();
    }

    public List<MongoVariable> getVars(ExecutableElement repositoryMethod, int count) {
        if (count == 0) {
            return List.of();
        }
        try {
            return IntStream.range(0, count).mapToObj(value -> this.iterator.next()).collect(Collectors.toList());
        }
        catch (NoSuchElementException ignore) {
            throw new InterruptProcessingException((Element)repositoryMethod, "Missing method parameter for parameter placeholder!", new Object[0]);
        }
    }

    public List<Variable> getUnusedVars() {
        ArrayList<Variable> res = new ArrayList<Variable>();
        while (this.iterator.hasNext()) {
            MongoVariable mongoVar = this.iterator.next();
            if (mongoVar.is(Pageable.class)) {
                if (!mongoVar.isLimit()) continue;
                res.add(mongoVar);
                continue;
            }
            res.add(mongoVar);
        }
        return res;
    }
}

