/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.mongo.component.impl;

import com.mongodb.BasicDBObject;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodBody;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.data.component.impl.AbstractDataRepositoryMethodModelBuilder;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.model.DataRepositoryMethodSignature;
import io.rxmicro.annotation.processor.data.model.Variable;
import io.rxmicro.annotation.processor.data.mongo.component.MongoRepositoryMethodModelBuilder;
import io.rxmicro.annotation.processor.data.mongo.component.impl.MethodParameterReader;
import io.rxmicro.annotation.processor.data.mongo.model.MongoDataModelField;
import io.rxmicro.annotation.processor.data.mongo.model.MongoDataObjectModelClass;
import io.rxmicro.annotation.processor.data.mongo.model.MongoMethodBody;
import io.rxmicro.annotation.processor.data.mongo.model.MongoRepositoryMethod;
import io.rxmicro.annotation.processor.data.mongo.model.MongoVariable;
import io.rxmicro.data.DataRepositoryGeneratorConfig;
import io.rxmicro.data.detail.adapter.PublisherToFluxFutureAdapter;
import io.rxmicro.data.detail.adapter.PublisherToOptionalMonoFutureAdapter;
import io.rxmicro.data.detail.adapter.PublisherToRequiredMonoFutureAdapter;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.bson.conversions.Bson;

public abstract class AbstractMongoRepositoryMethodModelBuilder
extends AbstractDataRepositoryMethodModelBuilder<MongoDataModelField, MongoRepositoryMethod, MongoDataObjectModelClass>
implements MongoRepositoryMethodModelBuilder {
    protected final MongoRepositoryMethod build(DataRepositoryMethodSignature dataRepositoryMethodSignature, MethodBody body) {
        return new MongoRepositoryMethod(dataRepositoryMethodSignature, body);
    }

    protected final void addCommonImports(ClassHeader.Builder classHeaderBuilder, MethodResult methodResult) {
        classHeaderBuilder.addImports(new Class[]{Bson.class, BasicDBObject.class});
        if (methodResult.isFuture()) {
            if (methodResult.isOneItem()) {
                if (methodResult.isOptional()) {
                    classHeaderBuilder.addImports(new Class[]{PublisherToOptionalMonoFutureAdapter.class});
                } else {
                    classHeaderBuilder.addImports(new Class[]{PublisherToRequiredMonoFutureAdapter.class});
                }
            } else {
                classHeaderBuilder.addImports(new Class[]{PublisherToFluxFutureAdapter.class, Collectors.class});
            }
        }
    }

    protected final MethodBody buildBody(ClassHeader.Builder classHeaderBuilder, ExecutableElement repositoryMethod, MethodResult methodResult, DataRepositoryGeneratorConfig dataRepositoryGeneratorConfig, DataGenerationContext<MongoDataModelField, MongoDataObjectModelClass> generationContext) {
        MethodParameterReader methodParameterReader = new MethodParameterReader(repositoryMethod.getParameters(), this.supportedTypesProvider);
        List<String> content = this.buildBody(classHeaderBuilder, repositoryMethod, methodResult, methodParameterReader, dataRepositoryGeneratorConfig, generationContext);
        this.validateUnusedMethodParameters(repositoryMethod, methodParameterReader);
        return new MongoMethodBody(content);
    }

    protected abstract List<String> buildBody(ClassHeader.Builder var1, ExecutableElement var2, MethodResult var3, MethodParameterReader var4, DataRepositoryGeneratorConfig var5, DataGenerationContext<MongoDataModelField, MongoDataObjectModelClass> var6);

    private void validateUnusedMethodParameters(ExecutableElement repositoryMethod, MethodParameterReader methodParameterReader) {
        List<Variable> unusedParameters = methodParameterReader.getUnusedVars();
        if (!unusedParameters.isEmpty()) {
            throw new InterruptProcessingException((Element)repositoryMethod, "The following parameter(s) unused: [?]. Remove it or add missing placeholder(s)!", new Object[]{unusedParameters.stream().map(Variable::toString).collect(Collectors.joining(", "))});
        }
    }

    protected final void setPageable(ExecutableElement repositoryMethod, MethodParameterReader methodParameterReader, Map<String, Object> templateArguments, Class<? extends Annotation> annotationClass, int limit, int skip) {
        if (limit > -1) {
            templateArguments.put("LIMIT", limit);
        }
        if (skip > -1) {
            templateArguments.put("SKIP", skip);
        }
        Optional<MongoVariable> limitVar = methodParameterReader.nextIfLimit();
        Optional<MongoVariable> skipVar = methodParameterReader.nextIfSkip();
        if (limitVar.isEmpty()) {
            limitVar = methodParameterReader.nextIfLimit();
        }
        limitVar.ifPresent(var -> {
            templateArguments.put("LIMIT", var.getGetter());
            if (limit > -1) {
                this.warn(repositoryMethod, "Method parameter '?' overrides annotation parameter: '?.limit()'", new Object[]{var.getName(), annotationClass.getName()});
            }
        });
        skipVar.ifPresent(var -> {
            templateArguments.put("SKIP", var.getGetter());
            if (skip > -1) {
                this.warn(repositoryMethod, "Method parameter '?' overrides annotation parameter: '?.skip()'", new Object[]{var.getName(), annotationClass.getName()});
            }
        });
    }
}

