/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.mongo.component.impl;

import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.data.model.Var;
import io.rxmicro.annotation.processor.data.mongo.model.MongoVar;
import io.rxmicro.common.util.Formats;
import io.rxmicro.data.Pageable;
import io.rxmicro.data.RepeatParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public final class MethodParameterReader {
    private final ListIterator<MongoVar> iterator;

    public MethodParameterReader(List<? extends VariableElement> parameters, SupportedTypesProvider supportedTypesProvider) {
        ArrayList<MongoVar> vars = new ArrayList<MongoVar>(parameters.size());
        VariableElement page = null;
        for (VariableElement variableElement : parameters) {
            String value = variableElement.getSimpleName().toString();
            if (!supportedTypesProvider.standardMethodParameters().contains(variableElement.asType())) {
                MongoVar var = new MongoVar(variableElement, value);
                int repeatCount = Optional.ofNullable(variableElement.getAnnotation(RepeatParameter.class)).map(RepeatParameter::value).orElse(1);
                for (int i = 0; i < repeatCount; ++i) {
                    vars.add(var);
                }
                continue;
            }
            if (!Pageable.class.getName().equals(variableElement.asType().toString())) continue;
            if (page != null) {
                throw new InterruptProcessingException((Element)variableElement, "Only one '?' parameter allowed per method!", new Object[]{Pageable.class.getName()});
            }
            page = variableElement;
            vars.add(new MongoVar(variableElement, Formats.format((String)"?.getLimit()", (Object[])new Object[]{value})));
            vars.add(new MongoVar(variableElement, Formats.format((String)"?.getSkip()", (Object[])new Object[]{value})));
        }
        this.iterator = vars.listIterator();
    }

    public Optional<MongoVar> nextVar() {
        return this.iterator.hasNext() ? Optional.of(this.iterator.next()) : Optional.empty();
    }

    public Optional<MongoVar> nextIfLimit() {
        return this.nextIf(MongoVar::isLimit);
    }

    public Optional<MongoVar> nextIfSkip() {
        return this.nextIf(MongoVar::isSkip);
    }

    private Optional<MongoVar> nextIf(Predicate<MongoVar> predicate) {
        if (this.iterator.hasNext()) {
            MongoVar mongoVar = this.iterator.next();
            if (predicate.test(mongoVar)) {
                return Optional.of(mongoVar);
            }
            this.iterator.previous();
        }
        return Optional.empty();
    }

    public List<MongoVar> getVars(ExecutableElement repositoryMethod, int count) {
        if (count == 0) {
            return List.of();
        }
        try {
            return IntStream.range(0, count).mapToObj(value -> this.iterator.next()).collect(Collectors.toList());
        }
        catch (NoSuchElementException e) {
            throw new InterruptProcessingException((Element)repositoryMethod, "Missing method parameter for parameter placeholder!", new Object[0]);
        }
    }

    public List<Var> getUnusedVars() {
        ArrayList<Var> res = new ArrayList<Var>();
        while (this.iterator.hasNext()) {
            MongoVar mongoVar = this.iterator.next();
            if (mongoVar.is(Pageable.class)) {
                if (!mongoVar.isLimit()) continue;
                res.add(mongoVar);
                continue;
            }
            res.add(mongoVar);
        }
        return res;
    }
}

