/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.mongo.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mongodb.BasicDBObject;
import io.rxmicro.annotation.processor.common.component.TokenParser;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.TokenParserResult;
import io.rxmicro.annotation.processor.common.model.TokenParserRule;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.data.model.Var;
import io.rxmicro.annotation.processor.data.mongo.component.BsonExpressionBuilder;
import io.rxmicro.annotation.processor.data.mongo.component.impl.MethodParameterReader;
import io.rxmicro.annotation.processor.data.mongo.model.BsonExpression;
import io.rxmicro.annotation.processor.data.mongo.model.BsonTokenParserRule;
import io.rxmicro.annotation.processor.data.mongo.model.MongoVar;
import io.rxmicro.common.util.Formats;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.bson.BsonBinarySubType;
import org.bson.UuidRepresentation;
import org.bson.internal.UuidHelper;
import org.bson.types.Binary;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

@Singleton
public final class BsonExpressionBuilderImpl
implements BsonExpressionBuilder {
    private static final String PREFIX = "#$%@_~";
    private static final Set<String> PLACEHOLDERS = Set.of(Formats.FORMAT_PLACEHOLDER_TOKEN, Formats.format((String)"'?'", (Object[])new Object[]{Formats.FORMAT_PLACEHOLDER_TOKEN}), Formats.format((String)"\"?\"", (Object[])new Object[]{Formats.FORMAT_PLACEHOLDER_TOKEN}));
    private static final Set<Class<?>> SUPPORTED_EXPRESSION_TYPES = Set.of(ObjectId.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigDecimal.class, Character.class, String.class, Instant.class, UUID.class);
    @Inject
    private TokenParser tokenParser;
    @Inject
    private BsonTokenParserRule bsonTokenParserRule;

    @Override
    public BsonExpression build(ExecutableElement repositoryMethod, ClassHeader.Builder classHeaderBuilder, String expressionTemplate, MethodParameterReader methodParameterReader) {
        BasicDBObject basicDBObject;
        Map.Entry<String, Integer> entry = this.getTempValidExpression(expressionTemplate);
        try {
            basicDBObject = BasicDBObject.parse((String)entry.getKey());
        }
        catch (RuntimeException e) {
            throw new InterruptProcessingException((Element)repositoryMethod, "Expression '?' is invalid: ?!", new Object[]{expressionTemplate, e.getMessage()});
        }
        List<MongoVar> arguments = methodParameterReader.getVars(repositoryMethod, entry.getValue());
        List<String> lines = this.getLines(repositoryMethod, classHeaderBuilder, arguments, basicDBObject);
        return new BsonExpression(expressionTemplate, lines);
    }

    private List<String> getLines(ExecutableElement repositoryMethod, ClassHeader.Builder classHeaderBuilder, List<MongoVar> arguments, BasicDBObject basicDBObject) {
        if (basicDBObject.size() == 1 && !(basicDBObject.values().iterator().next() instanceof BasicDBObject)) {
            Map.Entry entry = (Map.Entry)basicDBObject.entrySet().iterator().next();
            return List.of(Formats.format((String)"new Document(\"?\", ?);", (Object[])new Object[]{entry.getKey(), arguments.isEmpty() ? this.getSimpleValue(repositoryMethod, classHeaderBuilder, entry.getValue()) : this.getArgumentValue(arguments.get(0))}));
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("new Document()");
        this.extractCodeLines(repositoryMethod, classHeaderBuilder, lines, basicDBObject, arguments.iterator(), 1);
        lines.set(lines.size() - 1, (String)lines.get(lines.size() - 1) + ";");
        return lines;
    }

    private Map.Entry<String, Integer> getTempValidExpression(String template) {
        TokenParserResult result = this.tokenParser.parse(template, (TokenParserRule)this.bsonTokenParserRule, false);
        AtomicInteger index = new AtomicInteger(0);
        String exp = result.getTokens().stream().map(token -> {
            if (PLACEHOLDERS.contains(token)) {
                index.getAndIncrement();
                return "'#$%@_~'";
            }
            return token;
        }).collect(Collectors.joining(" "));
        return Map.entry(exp, index.get());
    }

    private void extractCodeLines(ExecutableElement repositoryMethod, ClassHeader.Builder classHeaderBuilder, List<String> lines, BasicDBObject basicDBObject, Iterator<MongoVar> varIterator, int shift) {
        for (Map.Entry entry : basicDBObject.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof BasicDBObject) {
                lines.add(Formats.format((String)"?.append(\"?\", new Document()", (Object[])new Object[]{this.spaces(shift), entry.getKey()}));
                this.extractCodeLines(repositoryMethod, classHeaderBuilder, lines, (BasicDBObject)value, varIterator, shift + 1);
                lines.add(this.spaces(shift) + ")");
                continue;
            }
            if (value instanceof String) {
                String string = (String)value;
                if (PREFIX.equals(string)) {
                    lines.add(Formats.format((String)"?.append(\"?\", ?)", (Object[])new Object[]{this.spaces(shift), entry.getKey(), this.getArgumentValue(varIterator.next())}));
                    continue;
                }
                lines.add(Formats.format((String)"?.append(\"?\", \"?\")", (Object[])new Object[]{this.spaces(shift), entry.getKey(), string}));
                continue;
            }
            lines.add(Formats.format((String)"?.append(\"?\", ?)", (Object[])new Object[]{this.spaces(shift), entry.getKey(), this.getSimpleValue(repositoryMethod, classHeaderBuilder, entry.getValue())}));
        }
    }

    private String getSimpleValue(ExecutableElement repositoryMethod, ClassHeader.Builder classHeaderBuilder, Object value) {
        if (value instanceof Long) {
            return Formats.format((String)"?L", (Object[])new Object[]{value});
        }
        if (value instanceof Decimal128) {
            classHeaderBuilder.addImports(new Class[]{BigDecimal.class});
            return Formats.format((String)"new BigDecimal(\"?\")", (Object[])new Object[]{value});
        }
        if (value instanceof ObjectId) {
            classHeaderBuilder.addImports(new Class[]{ObjectId.class});
            return Formats.format((String)"new ObjectId(\"?\")", (Object[])new Object[]{value});
        }
        if (value instanceof UUID) {
            classHeaderBuilder.addImports(new Class[]{UUID.class});
            return Formats.format((String)"UUID.fromString(\"?\")", (Object[])new Object[]{value});
        }
        if (value instanceof Date) {
            classHeaderBuilder.addImports(new Class[]{Instant.class});
            return Formats.format((String)"Instant.ofEpochMilli(?L)", (Object[])new Object[]{((Date)value).getTime()});
        }
        if (SUPPORTED_EXPRESSION_TYPES.contains(value.getClass())) {
            return value.toString();
        }
        if (value instanceof Binary && ((Binary)value).getType() == BsonBinarySubType.UUID_LEGACY.getValue()) {
            UUID uuid = UuidHelper.decodeBinaryToUuid((byte[])((Binary)value).getData(), (byte)BsonBinarySubType.UUID_LEGACY.getValue(), (UuidRepresentation)UuidRepresentation.JAVA_LEGACY);
            return Formats.format((String)"UUID.fromString(\"?\")", (Object[])new Object[]{uuid.toString()});
        }
        throw new InterruptProcessingException((Element)repositoryMethod, "'?' type is not supported as expression type! Use one of the following only: '?'", new Object[]{value.getClass(), SUPPORTED_EXPRESSION_TYPES});
    }

    private String getArgumentValue(Var var) {
        if (Elements.isNotStandardEnum((TypeMirror)var.getType())) {
            return Formats.format((String)"?.mongo()", (Object[])new Object[]{var.getName()});
        }
        return var.getGetter();
    }

    private String spaces(int shift) {
        return "        ".repeat(shift);
    }
}

