/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.mongo.component.impl.method;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import io.reactivex.rxjava3.core.Flowable;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.method.MethodResult;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.data.model.DataGenerationContext;
import io.rxmicro.annotation.processor.data.mongo.component.BsonExpressionBuilder;
import io.rxmicro.annotation.processor.data.mongo.component.impl.AbstractMongoRepositoryMethodModelBuilder;
import io.rxmicro.annotation.processor.data.mongo.component.impl.MethodParameterReader;
import io.rxmicro.annotation.processor.data.mongo.model.MongoDataModelField;
import io.rxmicro.annotation.processor.data.mongo.model.MongoDataObjectModelClass;
import io.rxmicro.data.DataRepositoryGeneratorConfig;
import io.rxmicro.data.mongo.detail.EntityFromMongoDBConverter;
import io.rxmicro.data.mongo.operation.Aggregate;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.bson.Document;
import reactor.core.publisher.Flux;

@Singleton
public final class AggregateOperationMongoRepositoryMethodModelBuilder
extends AbstractMongoRepositoryMethodModelBuilder {
    @Inject
    private BsonExpressionBuilder bsonExpressionBuilder;

    public Class<? extends Annotation> operationType() {
        return Aggregate.class;
    }

    @Override
    protected List<String> buildBody(ClassHeader.Builder classHeaderBuilder, ExecutableElement method, MethodResult methodResult, MethodParameterReader methodParameterReader, DataRepositoryGeneratorConfig dataRepositoryGeneratorConfig, DataGenerationContext<MongoDataModelField, MongoDataObjectModelClass> dataGenerationContext) {
        this.addImports(classHeaderBuilder);
        this.validateReturnType(method, methodResult.getResultType(), dataGenerationContext.getEntityResultTypes());
        HashMap<String, Object> templateArguments = new HashMap<String, Object>();
        this.putCommonArguments(dataRepositoryGeneratorConfig, templateArguments);
        templateArguments.put("RETURN", methodResult);
        templateArguments.put("ENTITY_CONVERTER", GeneratedClassNames.getModelTransformerInstanceName((TypeMirror)methodResult.getResultType(), EntityFromMongoDBConverter.class));
        Aggregate annotation = method.getAnnotation(Aggregate.class);
        String[] pipeline = annotation.pipeline();
        templateArguments.put("PIPELINE", Arrays.stream(pipeline).map(p -> this.bsonExpressionBuilder.build(method, classHeaderBuilder, (String)p, methodParameterReader)).collect(Collectors.toList()));
        String hint = annotation.hint();
        if (!hint.trim().isEmpty()) {
            templateArguments.put("HINT", this.bsonExpressionBuilder.build(method, classHeaderBuilder, hint, methodParameterReader));
        }
        templateArguments.put("ALLOW_DISK_USE", annotation.allowDiskUse());
        return this.methodBodyGenerator.generate("data/mongo/method/$$MongoRepositoryAggregateMethodBodyTemplate.javaftl", templateArguments);
    }

    private void addImports(ClassHeader.Builder classHeaderBuilder) {
        classHeaderBuilder.addImports(new Class[]{Document.class, AggregatePublisher.class, List.class, Arrays.class, Flux.class, Flowable.class, ArrayList.class});
    }
}

